/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.types;

import com.querydsl.sql.types.AbstractJSR310DateTimeType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.jetbrains.annotations.Nullable;

public class LocalDateTimeType
extends AbstractJSR310DateTimeType<LocalDateTime> {
    public LocalDateTimeType() {
        super(93);
    }

    public LocalDateTimeType(int type) {
        super(type);
    }

    @Override
    public String getLiteral(LocalDateTime value) {
        return dateTimeFormatter.format(value);
    }

    @Override
    public Class<LocalDateTime> getReturnedClass() {
        return LocalDateTime.class;
    }

    @Override
    @Nullable
    public LocalDateTime getValue(ResultSet rs, int startIndex) throws SQLException {
        try {
            return rs.getObject(startIndex, LocalDateTime.class);
        }
        catch (SQLException e) {
            Timestamp timestamp = rs.getTimestamp(startIndex);
            if (timestamp == null) {
                return null;
            }
            return timestamp.toLocalDateTime();
        }
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, LocalDateTime value) throws SQLException {
        st.setObject(startIndex, value);
    }
}

