/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.parser.CSSParser;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.svgsupport.PDFTranscoder;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Point;
import java.util.Set;
import java.util.logging.Level;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BatikSVGImage
implements SVGDrawer.SVGImage {
    private static final int DEFAULT_SVG_WIDTH = 400;
    private static final int DEFAULT_SVG_HEIGHT = 400;
    private static final Point DEFAULT_DIMENSIONS = new Point(400, 400);
    private final Element svgElement;
    private final double dotsPerPixel;
    private PDFTranscoder.OpenHtmlFontResolver fontResolver;
    private final PDFTranscoder pdfTranscoder;
    private UserAgentCallback userAgentCallback;

    public BatikSVGImage(Element svgElement, Box box, double cssWidth, double cssHeight, double cssMaxWidth, double cssMaxHeight, double dotsPerPixel, CssContext ctx) {
        double h;
        double w;
        Point dimensions;
        this.svgElement = svgElement;
        this.dotsPerPixel = dotsPerPixel;
        this.pdfTranscoder = new PDFTranscoder(box, dotsPerPixel, cssWidth, cssHeight);
        if (cssWidth >= 0.0) {
            this.pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf((float)(cssWidth / dotsPerPixel)));
        }
        if (cssHeight >= 0.0) {
            this.pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf((float)(cssHeight / dotsPerPixel)));
        }
        if (cssMaxWidth >= 0.0) {
            this.pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, Float.valueOf((float)(cssMaxWidth / dotsPerPixel)));
        }
        if (cssMaxHeight >= 0.0) {
            this.pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, Float.valueOf((float)(cssMaxHeight / dotsPerPixel)));
        }
        if ((dimensions = this.parseDimensions(svgElement, box, ctx)) == DEFAULT_DIMENSIONS) {
            if (cssWidth >= 0.0 && cssHeight >= 0.0) {
                w = cssWidth / dotsPerPixel;
                h = cssHeight / dotsPerPixel;
            } else if (cssWidth >= 0.0) {
                w = cssWidth / dotsPerPixel;
                h = 400.0;
            } else if (cssHeight >= 0.0) {
                w = 400.0;
                h = cssHeight / dotsPerPixel;
            } else {
                w = 400.0;
                h = 400.0;
            }
        } else {
            w = dimensions.x;
            h = dimensions.y;
        }
        svgElement.setAttribute("width", Integer.toString((int)w));
        svgElement.setAttribute("height", Integer.toString((int)h));
        this.pdfTranscoder.setImageSize((float)w, (float)h);
    }

    public int getIntrinsicWidth() {
        return (int)((double)this.pdfTranscoder.getWidth() * this.dotsPerPixel);
    }

    public int getIntrinsicHeight() {
        return (int)((double)this.pdfTranscoder.getHeight() * this.dotsPerPixel);
    }

    public void setFontResolver(PDFTranscoder.OpenHtmlFontResolver fontResolver) {
        this.fontResolver = fontResolver;
    }

    public void setSecurityOptions(boolean allowScripts, boolean allowExternalResources, Set<String> allowedProtocols) {
        this.pdfTranscoder.setSecurityOptions(allowScripts, allowExternalResources, allowedProtocols);
        this.pdfTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_EXECUTE_ONLOAD, allowScripts);
    }

    public void setUserAgentCallback(UserAgentCallback userAgentCallback) {
        this.userAgentCallback = userAgentCallback;
    }

    private Integer parseLength(String attrValue, CSSName property, Box box, CssContext ctx) {
        try {
            return Integer.valueOf(attrValue);
        }
        catch (NumberFormatException e) {
            CSSParser parser = new CSSParser((uri, msg) -> XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_INVALID_INTEGER_PASSED_AS_DIMENSION_FOR_SVG, (Object)attrValue));
            PropertyValue value = parser.parsePropertyValue(property, 2, attrValue);
            if (value == null) {
                return null;
            }
            LengthValue length = new LengthValue(box.getStyle(), property, value);
            float pixels = length.getFloatProportionalTo(property, box.getContainingBlock() == null ? 0.0f : (float)box.getContainingBlock().getWidth(), ctx);
            return (int)Math.round((double)pixels / this.dotsPerPixel);
        }
    }

    private Point parseWidthHeightAttributes(Element e, Box box, CssContext ctx) {
        Integer height;
        String widthAttr = e.getAttribute("width");
        Integer width = widthAttr.isEmpty() ? null : this.parseLength(widthAttr, CSSName.WIDTH, box, ctx);
        String heightAttr = e.getAttribute("height");
        Integer n = height = heightAttr.isEmpty() ? null : this.parseLength(heightAttr, CSSName.HEIGHT, box, ctx);
        if (width != null && height != null) {
            return new Point(width, height);
        }
        return DEFAULT_DIMENSIONS;
    }

    private Point parseDimensions(Element e, Box box, CssContext ctx) {
        String viewBoxAttr = e.getAttribute("viewBox");
        String[] splitViewBox = viewBoxAttr.split("\\s+");
        if (splitViewBox.length != 4) {
            return this.parseWidthHeightAttributes(e, box, ctx);
        }
        try {
            int viewBoxWidth = Integer.parseInt(splitViewBox[2]);
            int viewBoxHeight = Integer.parseInt(splitViewBox[3]);
            return new Point(viewBoxWidth, viewBoxHeight);
        }
        catch (NumberFormatException ex) {
            return this.parseWidthHeightAttributes(e, box, ctx);
        }
    }

    public void drawSVG(OutputDevice outputDevice, RenderingContext ctx, double x, double y) {
        PDFTranscoder.OpenHtmlFontResolver fontResolver = this.fontResolver;
        if (fontResolver == null) {
            XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.GENERAL_IMPORT_FONT_FACE_RULES_HAS_NOT_BEEN_CALLED);
            fontResolver = new PDFTranscoder.OpenHtmlFontResolver();
        }
        this.pdfTranscoder.setRenderingParameters(outputDevice, ctx, x, y, fontResolver, this.userAgentCallback);
        String styles = ctx.getCss().getCSSForAllDescendants(this.svgElement);
        try {
            int i;
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            Document newDocument = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
            if (styles != null && !styles.isEmpty()) {
                Element styleElem = newDocument.createElementNS("http://www.w3.org/2000/svg", "style");
                Text styleText = newDocument.createTextNode(styles);
                styleElem.appendChild(styleText);
                newDocument.getDocumentElement().appendChild(styleElem);
            }
            for (i = 0; i < this.svgElement.getChildNodes().getLength(); ++i) {
                Node importedNode = newDocument.importNode(this.svgElement.getChildNodes().item(i), true);
                newDocument.getDocumentElement().appendChild(importedNode);
            }
            for (i = 0; i < this.svgElement.getAttributes().getLength(); ++i) {
                Node importedAttr = this.svgElement.getAttributes().item(i);
                newDocument.getDocumentElement().setAttribute(importedAttr.getNodeName(), importedAttr.getNodeValue());
            }
            TranscoderInput in = new TranscoderInput(newDocument);
            this.pdfTranscoder.transcode(in, null);
        }
        catch (TranscoderException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_SVG_COULD_NOT_DRAW, (Throwable)e);
        }
    }
}

