/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.svgsupport.OpenHtmlGvtGlyphVector;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.logging.Level;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;

public class OpenHtmlGvtFont
implements GVTFont {
    private final Font baseFont;
    private final GVTFontFamily fontFamily;

    private static int toFontWeight(Float weight) {
        if (weight == null) {
            return 0;
        }
        if (weight.floatValue() <= TextAttribute.WEIGHT_BOLD.floatValue()) {
            return 0;
        }
        return 1;
    }

    private static int toStyle(Float posture) {
        return posture != null && (double)posture.floatValue() > 0.0 ? 2 : 0;
    }

    public OpenHtmlGvtFont(File fontFile, GVTFontFamily family, float size, Float fontWeight, Float fontStyle) throws IOException, FontFormatException {
        Font font;
        this.baseFont = font = Font.createFont(0, fontFile);
        this.fontFamily = family;
    }

    public OpenHtmlGvtFont(byte[] fontBytes, GVTFontFamily family, float size, Float fontWeight, Float fontStyle) throws FontFormatException {
        Font font;
        try {
            font = Font.createFont(0, new ByteArrayInputStream(fontBytes)).deriveFont(OpenHtmlGvtFont.toFontWeight(fontWeight) | OpenHtmlGvtFont.toStyle(fontStyle), size);
        }
        catch (IOException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_SVG_CREATE_FONT, (Object)(family != null ? family.getFamilyName() : ""), (Throwable)e);
            font = null;
        }
        this.baseFont = font;
        this.fontFamily = family;
    }

    private OpenHtmlGvtFont(Font font, GVTFontFamily family, float size) {
        this.baseFont = font;
        this.fontFamily = family;
    }

    public boolean canDisplay(char c) {
        return this.baseFont.canDisplay(c);
    }

    public int canDisplayUpTo(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.baseFont.canDisplay(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int canDisplayUpTo(char[] str, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (this.baseFont.canDisplay(str[i])) continue;
            return i;
        }
        return -1;
    }

    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        char c = iter.setIndex(start);
        while (iter.getIndex() < limit) {
            if (!this.canDisplay(c)) {
                return iter.getIndex();
            }
            c = iter.next();
        }
        return -1;
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext frc, char[] arg1) {
        return this.createGlyphVector(frc, new String(arg1));
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext frc, CharacterIterator arg1) {
        return new OpenHtmlGvtGlyphVector(this.baseFont.createGlyphVector(frc, arg1), this, frc);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext frc, String arg1) {
        return new OpenHtmlGvtGlyphVector(this.baseFont.createGlyphVector(frc, arg1), this, frc);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext frc, int[] arg1, CharacterIterator arg2) {
        throw new UnsupportedOperationException();
    }

    public GVTFont deriveFont(float arg0) {
        Font newFont = this.baseFont.deriveFont(arg0);
        return new OpenHtmlGvtFont(newFont, this.fontFamily, arg0);
    }

    public String getFamilyName() {
        return this.fontFamily.getFamilyName();
    }

    public float getHKern(int arg0, int arg1) {
        return 0.0f;
    }

    public GVTLineMetrics getLineMetrics(String arg0, FontRenderContext arg1) {
        return new GVTLineMetrics(this.baseFont.getLineMetrics(arg0, arg1));
    }

    public GVTLineMetrics getLineMetrics(char[] arg0, int arg1, int arg2, FontRenderContext arg3) {
        return new GVTLineMetrics(this.baseFont.getLineMetrics(arg0, arg1, arg2, arg3));
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator arg0, int arg1, int arg2, FontRenderContext arg3) {
        return new GVTLineMetrics(this.baseFont.getLineMetrics(arg0, arg1, arg2, arg3));
    }

    public GVTLineMetrics getLineMetrics(String arg0, int arg1, int arg2, FontRenderContext arg3) {
        return new GVTLineMetrics(this.baseFont.getLineMetrics(arg0, arg1, arg2, arg3));
    }

    public float getSize() {
        return (float)this.baseFont.getSize() / 1000.0f;
    }

    public float getVKern(int arg0, int arg1) {
        return 0.0f;
    }
}

