/*
 * Decompiled with CFR 0.152.
 */
package io.github.openlg.graphlib;

import io.github.openlg.graphlib.Edge;
import io.github.openlg.graphlib.IllegalOperationException;
import io.github.openlg.graphlib.Utils;
import io.github.openlg.graphlib.algorithms.Components;
import io.github.openlg.graphlib.algorithms.FindCycles;
import io.github.openlg.graphlib.algorithms.IsAcyclic;
import io.github.openlg.graphlib.algorithms.Tarjan;
import io.github.openlg.graphlib.algorithms.Topsort;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Graph<N, E>
implements Serializable {
    private static final String DEFAULT_EDGE_NAME = "\\x00";
    private static final String GRAPH_NODE = "\\x00";
    private static final String EDGE_KEY_DELIM = "\\x01";
    private boolean directed;
    private boolean multiGraph;
    private boolean compound;
    private Map<String, N> nodes = new LinkedHashMap<String, N>();
    private Map<String, Map<String, Edge>> in = new HashMap<String, Map<String, Edge>>();
    private Map<String, Map<String, Integer>> pred = new HashMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Edge>> out = new HashMap<String, Map<String, Edge>>();
    private Map<String, Map<String, Integer>> sucs = new HashMap<String, Map<String, Integer>>();
    private Map<String, Edge> edgeObjs = new HashMap<String, Edge>();
    private Map<String, E> edgeLabels = new HashMap<String, E>();
    private Map<String, String> parent = null;
    private Map<String, HashMap<String, Boolean>> children = null;
    private int nodeCount = 0;
    private int edgeCount = 0;

    public Graph() {
        this(true, false, false);
    }

    public Graph(boolean directed, boolean multigraph, boolean compound) {
        this.directed = directed;
        this.multiGraph = multigraph;
        this.compound = compound;
        if (this.isCompound()) {
            this.parent = new HashMap<String, String>();
            this.children = new HashMap<String, HashMap<String, Boolean>>();
            this.children.put("\\x00", new HashMap());
        }
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    public Collection<String> getNodes() {
        return this.nodes.keySet();
    }

    public N getNode(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public Set<String> getSources() {
        return this.getNodes().stream().filter(node -> !this.in.containsKey(node) || this.in.get(node).size() == 0).collect(Collectors.toSet());
    }

    public Set<String> getSinks() {
        return this.getNodes().stream().filter(node -> !this.out.containsKey(node) || this.out.get(node).size() == 0).collect(Collectors.toSet());
    }

    public Graph<N, E> setNode(String id) {
        return this.setNode(id, null, false);
    }

    public Graph<N, E> setNode(String id, N n) {
        return this.setNode(id, n, true);
    }

    private Graph<N, E> setNode(String id, N n, boolean replaceValue) {
        if (this.nodes.containsKey(id)) {
            if (replaceValue) {
                this.nodes.replace(id, n);
            }
            return this;
        }
        this.nodes.put(id, n);
        if (this.isCompound()) {
            this.parent.put(id, "\\x00");
            this.children.put(id, new HashMap());
            this.children.get("\\x00").put(id, true);
        }
        this.in.put(id, new HashMap());
        this.pred.put(id, new HashMap());
        this.out.put(id, new HashMap());
        this.sucs.put(id, new HashMap());
        ++this.nodeCount;
        return this;
    }

    public Graph<N, E> setNodes(Collection<String> nodes) {
        return this.setNodes(nodes, null);
    }

    public Graph<N, E> setNodes(Collection<String> nodes, N n) {
        if (nodes != null) {
            nodes.forEach(id -> this.setNode((String)id, n));
        }
        return this;
    }

    public boolean hasNode(String id) {
        return this.nodes.containsKey(id);
    }

    public Graph<N, E> removeNode(String id) {
        if (this.hasNode(id)) {
            this.nodes.remove(id);
            if (this.isCompound()) {
                this.removeFromParentsChildList(id);
                this.parent.remove(id);
                new HashSet<String>(this.getChildren(id)).forEach(_id -> this.setParent((String)_id, null));
                this.children.remove(id);
            }
            new HashSet<String>(this.in.get(id).keySet()).forEach(edgeId -> this.removeEdge(this.edgeObjs.get(edgeId)));
            this.in.remove(id);
            this.pred.remove(id);
            new HashSet<String>(this.out.get(id).keySet()).forEach(edgeId -> this.removeEdge(this.edgeObjs.get(edgeId)));
            this.out.remove(id);
            this.sucs.remove(id);
            --this.nodeCount;
        }
        return this;
    }

    public int edgeCount() {
        return this.edgeCount;
    }

    public Collection<Edge> getEdges() {
        return this.edgeObjs.values();
    }

    public E getEdge(Edge edge) {
        return this.getEdge(edge.getSource(), edge.getTarget(), edge.getName());
    }

    public E getEdge(String sourceId, String targetId) {
        return this.getEdge(sourceId, targetId, null);
    }

    public E getEdge(String sourceId, String targetId, String name) {
        String edgeId = this.edgeArgsToId(this.directed, sourceId, targetId, name);
        return this.edgeLabels.get(edgeId);
    }

    public Graph<N, E> setEdge(String sourceId, String targetId) {
        return this.setEdge(sourceId, targetId, null, null);
    }

    public Graph<N, E> setEdge(String sourceId, String targetId, E e) {
        return this.setEdge(sourceId, targetId, e, null);
    }

    public Graph<N, E> setEdge(Edge edge) {
        return this.setEdge(edge, null);
    }

    public Graph<N, E> setEdge(Edge edge, E e) {
        return this.setEdge(edge.getSource(), edge.getTarget(), e, edge.getName());
    }

    public Graph<N, E> setEdge(String sourceId, String targetId, E e, String name) {
        String edgeId = this.edgeArgsToId(this.directed, sourceId, targetId, name);
        if (this.edgeLabels.containsKey(edgeId)) {
            this.edgeLabels.replace(edgeId, e);
            return this;
        }
        if (!Utils.isEmpty(name) && !this.multiGraph) {
            throw new IllegalOperationException("Cannot set a named getEdge when multiGraph = false");
        }
        this.setNode(sourceId, null, false);
        this.setNode(targetId, null, false);
        Edge edgeObj = this.edgeArgsToEdge(this.directed, sourceId, targetId, name);
        sourceId = edgeObj.getSource();
        targetId = edgeObj.getTarget();
        this.edgeLabels.put(edgeId, e);
        this.edgeObjs.put(edgeId, edgeObj);
        this.in.get(targetId).put(edgeId, edgeObj);
        Integer linkCounter = this.pred.get(targetId).getOrDefault(sourceId, 0);
        linkCounter = linkCounter + 1;
        this.pred.get(targetId).put(sourceId, linkCounter);
        this.out.get(sourceId).put(edgeId, edgeObj);
        linkCounter = this.sucs.get(sourceId).getOrDefault(targetId, 0);
        linkCounter = linkCounter + 1;
        this.sucs.get(sourceId).put(targetId, linkCounter);
        ++this.edgeCount;
        return this;
    }

    public boolean hasEdge(Edge edge) {
        return this.hasEdge(edge.getSource(), edge.getTarget(), edge.getName());
    }

    public boolean hasEdge(String sourceId, String targetId) {
        return this.hasEdge(sourceId, targetId, null);
    }

    public boolean hasEdge(String sourceId, String targetId, String name) {
        String edgeId = this.edgeArgsToId(this.directed, sourceId, targetId, name);
        return this.edgeLabels.containsKey(edgeId);
    }

    public Graph<N, E> removeEdge(Edge edge) {
        return this.removeEdge(edge.getSource(), edge.getTarget(), edge.getName());
    }

    public Graph<N, E> removeEdge(String sourceId, String targetId) {
        return this.removeEdge(sourceId, targetId, null);
    }

    public Graph<N, E> removeEdge(String sourceId, String targetId, String name) {
        String edgeId = this.edgeArgsToId(this.directed, sourceId, targetId, name);
        Edge edge = this.edgeObjs.remove(edgeId);
        if (edge != null) {
            sourceId = edge.getSource();
            targetId = edge.getTarget();
            this.edgeLabels.remove(edgeId);
            this.in.get(targetId).remove(edgeId);
            this.out.get(sourceId).remove(edgeId);
            this.decrementOrRemoveEntry(this.sucs.get(sourceId), targetId);
            this.decrementOrRemoveEntry(this.pred.get(targetId), sourceId);
            --this.edgeCount;
        }
        return this;
    }

    public Graph<N, E> setPath(Collection<String> path) {
        return this.setPath(path, null);
    }

    public Graph<N, E> setPath(String ... nodeId) {
        return this.setPath(Arrays.asList(nodeId), null);
    }

    public Graph<N, E> setPath(Collection<String> path, E e) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot set null path in graph");
        }
        path.stream().reduce((first, second) -> {
            this.setEdge((String)first, (String)second, e);
            return second;
        }).get();
        return this;
    }

    public Collection<Edge> inEdges(String nodeId) {
        return this.inEdges(nodeId, null);
    }

    public Collection<Edge> inEdges(String nodeId, String sourceId) {
        Map<String, Edge> edges = this.in.get(nodeId);
        if (edges != null) {
            Collection<Edge> inEdges = edges.values();
            if (sourceId == null) {
                return inEdges;
            }
            return inEdges.stream().filter(edge -> sourceId.equals(edge.getSource())).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    public Collection<Edge> outEdges(String nodeId) {
        return this.outEdges(nodeId, null);
    }

    public Collection<Edge> outEdges(String nodeId, String targetId) {
        Map<String, Edge> edges = this.out.get(nodeId);
        if (edges != null) {
            Collection<Edge> outEdges = edges.values();
            if (targetId == null) {
                return outEdges;
            }
            return outEdges.stream().filter(edge -> targetId.equals(edge.getTarget())).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    public Collection<Edge> nodeEdges(String nodeId) {
        return this.nodeEdges(nodeId, null);
    }

    public Collection<Edge> nodeEdges(String nodeId, String connectedNodeId) {
        Collection<Edge> _inEdges = this.inEdges(nodeId, connectedNodeId);
        return Stream.concat(_inEdges.stream(), this.outEdges(nodeId, connectedNodeId).stream()).collect(Collectors.toList());
    }

    public Collection<String> predecessors(String nodeId) {
        if (this.hasNode(nodeId)) {
            return new HashSet<String>(this.pred.get(nodeId).keySet());
        }
        return Collections.emptyList();
    }

    public Collection<String> successors(String nodeId) {
        if (this.hasNode(nodeId)) {
            return new HashSet<String>(this.sucs.get(nodeId).keySet());
        }
        return Collections.emptyList();
    }

    public Collection<String> neighbors(String nodeId) {
        Collection<String> pred = this.predecessors(nodeId);
        Collection<String> sucs = this.successors(nodeId);
        if (pred != null && sucs != null) {
            pred.addAll(sucs);
        }
        return pred != null ? pred : (sucs != null ? sucs : Collections.emptyList());
    }

    public Graph<N, E> setParent(String nodeId, String parentId) {
        if (!this.isCompound()) {
            throw new IllegalOperationException("Cannot set parent in a non-compound graph");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Cannot set parent to null");
        }
        if (parentId == null) {
            parentId = "\\x00";
        } else {
            String ancestor = parentId;
            while (ancestor != null) {
                if (nodeId.equals(ancestor)) {
                    throw new IllegalOperationException("Setting " + parentId + "as parent of " + nodeId + " would create a cycle.");
                }
                ancestor = this.getParent(ancestor);
            }
            this.setNode(parentId, null, false);
        }
        this.setNode(nodeId, null, false);
        this.removeFromParentsChildList(nodeId);
        this.parent.put(nodeId, parentId);
        if (!this.children.containsKey(parentId)) {
            this.children.put(parentId, new HashMap());
        }
        this.children.get(parentId).put(nodeId, true);
        return this;
    }

    private void removeFromParentsChildList(String nodeId) {
        this.children.get(this.parent.get(nodeId)).remove(nodeId);
    }

    public String getParent(String nodeId) {
        String parent;
        if (this.isCompound() && !"\\x00".equals(parent = this.parent.get(nodeId))) {
            return parent;
        }
        return null;
    }

    public Collection<String> getChildren(String nodeId) {
        if (nodeId == null) {
            nodeId = "\\x00";
        }
        if (this.isCompound()) {
            HashMap<String, Boolean> childes = this.children.get(nodeId);
            return childes != null ? childes.keySet() : null;
        }
        if ("\\x00".equals(nodeId)) {
            return this.nodes.keySet();
        }
        return this.nodes.containsKey(nodeId) ? Collections.emptyList() : null;
    }

    public Graph<N, E> filterNodes(Predicate<String> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Unable to filter nodes based on null filter");
        }
        Graph copy = new Graph(this.directed, this.multiGraph, this.compound);
        this.nodes.forEach((nodeId, value) -> {
            if (filter.test((String)nodeId)) {
                copy.setNode((String)nodeId, (Object)value);
            }
        });
        this.edgeObjs.forEach((nodeId, edge) -> {
            if (copy.hasNode(edge.getSource()) && copy.hasNode(edge.getTarget())) {
                copy.setEdge((Edge)edge, this.getEdge((Edge)edge));
            }
        });
        if (this.isCompound()) {
            HashMap parents = new HashMap();
            copy.getNodes().forEach(nodeId -> copy.setParent((String)nodeId, this.findParent((String)nodeId, copy, parents)));
        }
        return copy;
    }

    public boolean isLeaf(String nodeId) {
        Collection<String> neighbors = this.isDirected() ? this.successors(nodeId) : this.neighbors(nodeId);
        return neighbors == null || neighbors.size() == 0;
    }

    private String findParent(String node, Graph<N, E> copy, Map<String, String> parents) {
        String parent = this.getParent(node);
        if (parent == null || copy.hasNode(parent)) {
            parents.put(node, parent);
            return parent;
        }
        if (parents.containsKey(parent)) {
            return parents.get(parent);
        }
        return this.findParent(parent, copy, parents);
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public boolean isMultiGraph() {
        return this.multiGraph;
    }

    public void setMultiGraph(boolean multiGraph) {
        this.multiGraph = multiGraph;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setCompound(boolean compound) {
        this.compound = compound;
    }

    private String edgeObjToId(boolean isDirected, Edge edge) {
        return this.edgeArgsToId(isDirected, edge.getSource(), edge.getTarget(), edge.getName());
    }

    private String edgeArgsToId(boolean isDirected, String sourceId, String targetId, String name) {
        if (!isDirected && sourceId.compareTo(targetId) > 0) {
            String tmp = sourceId;
            sourceId = targetId;
            targetId = tmp;
        }
        return sourceId + EDGE_KEY_DELIM + targetId + EDGE_KEY_DELIM + (name != null ? name : "\\x00");
    }

    private Edge edgeArgsToEdge(boolean isDirected, String sourceId, String targetId, String name) {
        if (!isDirected && sourceId.compareTo(targetId) > 0) {
            String tmp = sourceId;
            sourceId = targetId;
            targetId = tmp;
        }
        return new Edge(sourceId, targetId, name);
    }

    private void decrementOrRemoveEntry(Map<String, Integer> map, String k) {
        if (map.containsKey(k)) {
            Integer count = map.get(k);
            if ((count = Integer.valueOf(count - 1)) == 0) {
                map.remove(k);
            } else {
                map.replace(k, count);
            }
        }
    }

    public List<Graph<N, E>> components() {
        return new Components().getComponents(this);
    }

    public List<List<String>> tarjan() {
        return new Tarjan().tarjan(this);
    }

    public List<String> topsort() {
        return new Topsort().topsort(this);
    }

    public boolean isAcyclic() {
        return new IsAcyclic().isAcyclic(this);
    }

    public List<List<String>> findCycles() {
        return new FindCycles().findCycles(this);
    }
}

