/*
 * Decompiled with CFR 0.152.
 */
package io.github.openlg.graphlib.algorithms;

import io.github.openlg.graphlib.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Components {
    public <N, E> List<Graph<N, E>> getComponents(Graph<N, E> graph) {
        HashMap visited = new HashMap();
        ArrayList graphs = new ArrayList();
        graph.getNodes().forEach(nodeId -> {
            Graph component = new Graph();
            this.findComponent(visited, graph, (String)nodeId, component);
            if (component.nodeCount() > 0) {
                graphs.add(component);
            }
        });
        return graphs;
    }

    private <N, E> void findComponent(Map<String, Boolean> visited, Graph<N, E> graph, String nodeId, Graph<N, E> component) {
        if (visited.containsKey(nodeId)) {
            return;
        }
        visited.put(nodeId, true);
        component.setNode(nodeId, graph.getNode(nodeId));
        graph.successors(nodeId).forEach(successor -> {
            this.findComponent(visited, graph, (String)successor, component);
            component.setEdge(nodeId, (String)successor, graph.getEdge(nodeId, (String)successor));
        });
        graph.predecessors(nodeId).forEach(predecessor -> {
            this.findComponent(visited, graph, (String)predecessor, component);
            component.setEdge((String)predecessor, nodeId, graph.getEdge((String)predecessor, nodeId));
        });
    }
}

