/*
 * Decompiled with CFR 0.152.
 */
package io.github.openlg.graphlib.algorithms;

import io.github.openlg.graphlib.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tarjan {
    private int index = 0;
    private List<String> stack = new ArrayList<String>();
    private Map<String, Entry> visited = new HashMap<String, Entry>();
    private List<List<String>> result = new ArrayList<List<String>>();

    public <N, E> List<List<String>> tarjan(Graph<N, E> graph) {
        this.index = 0;
        this.stack = new ArrayList<String>();
        this.visited = new HashMap<String, Entry>();
        this.result = new ArrayList<List<String>>();
        graph.getNodes().forEach(nodeId -> {
            if (!this.visited.containsKey(nodeId)) {
                this.recursion(graph, (String)nodeId);
            }
        });
        return this.result;
    }

    private <E, N> void recursion(Graph<N, E> graph, String nodeId) {
        Entry entry;
        if (this.visited.containsKey(nodeId)) {
            entry = this.visited.get(nodeId);
        } else {
            entry = new Entry();
            this.visited.put(nodeId, entry);
        }
        entry.onStack = true;
        entry.lowLink = this.index;
        entry.index = this.index++;
        this.stack.add(nodeId);
        graph.successors(nodeId).forEach(successor -> {
            if (!this.visited.containsKey(successor)) {
                this.recursion(graph, (String)successor);
                entry.lowLink = Math.min(entry.lowLink, this.visited.get((Object)successor).lowLink);
            } else if (this.visited.get((Object)successor).onStack) {
                entry.lowLink = Math.min(entry.lowLink, this.visited.get((Object)successor).index);
            }
        });
        if (entry.lowLink == entry.index) {
            String w;
            ArrayList<String> comp = new ArrayList<String>();
            do {
                if (this.stack.size() > 0) {
                    w = this.stack.remove(this.stack.size() - 1);
                    this.visited.get((Object)w).onStack = false;
                    comp.add(w);
                    continue;
                }
                w = null;
            } while (w != null && !w.equals(nodeId));
            this.result.add(comp);
        }
    }

    private class Entry {
        boolean onStack = true;
        int lowLink = 0;
        int index = 0;

        private Entry() {
        }
    }
}

