/*
 * Decompiled with CFR 0.152.
 */
package io.github.openlg.graphlib.algorithms;

import io.github.openlg.graphlib.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Topsort {
    public <N, E> List<String> topsort(Graph<N, E> graph) {
        HashMap visited = new HashMap();
        HashMap stack = new HashMap();
        ArrayList<String> results = new ArrayList<String>();
        graph.getSinks().forEach(sinkId -> this.visit(graph, stack, visited, (List<String>)results, (String)sinkId));
        if (visited.size() != graph.nodeCount()) {
            throw new CycleException();
        }
        return results;
    }

    private <N, E> void visit(Graph<N, E> graph, Map<String, Boolean> stack, Map<String, Boolean> visited, List<String> results, String nodeId) {
        if (stack.containsKey(nodeId)) {
            throw new CycleException();
        }
        if (!visited.containsKey(nodeId)) {
            stack.put(nodeId, true);
            visited.put(nodeId, true);
            graph.predecessors(nodeId).forEach(predecessor -> this.visit(graph, stack, visited, results, (String)predecessor));
            stack.remove(nodeId);
            results.add(nodeId);
        }
    }

    public static class CycleException
    extends RuntimeException {
    }
}

