/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.mapper;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicImageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicRole;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTool;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolResultContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolSchema;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolUseContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AnthropicMapper {
    public static List<AnthropicMessage> toAnthropicMessages(List<ChatMessage> messages) {
        ArrayList<AnthropicMessage> anthropicMessages = new ArrayList<AnthropicMessage>();
        ArrayList<AnthropicMessageContent> toolContents = new ArrayList<AnthropicMessageContent>();
        for (ChatMessage message : messages) {
            List<AnthropicMessageContent> contents;
            if (message instanceof ToolExecutionResultMessage) {
                toolContents.add(AnthropicMapper.toAnthropicToolResultContent((ToolExecutionResultMessage)message));
                continue;
            }
            if (!toolContents.isEmpty()) {
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
                toolContents = new ArrayList();
            }
            if (message instanceof UserMessage) {
                contents = AnthropicMapper.toAnthropicMessageContents((UserMessage)message);
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, contents));
                continue;
            }
            if (!(message instanceof AiMessage)) continue;
            contents = AnthropicMapper.toAnthropicMessageContents((AiMessage)message);
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.ASSISTANT, contents));
        }
        if (!toolContents.isEmpty()) {
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
        }
        return anthropicMessages;
    }

    private static AnthropicToolResultContent toAnthropicToolResultContent(ToolExecutionResultMessage message) {
        return new AnthropicToolResultContent(message.id(), message.text(), null);
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(UserMessage message) {
        return message.contents().stream().map(content -> {
            if (content instanceof TextContent) {
                return new AnthropicTextContent(((TextContent)content).text());
            }
            if (content instanceof ImageContent) {
                Image image = ((ImageContent)content).image();
                if (image.url() != null) {
                    throw Exceptions.illegalArgument((String)"Anthropic does not support images as URLs, only as Base64-encoded strings", (Object[])new Object[0]);
                }
                return new AnthropicImageContent(ValidationUtils.ensureNotBlank((String)image.mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)image.base64Data(), (String)"base64Data"));
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + content), (Object[])new Object[0]);
        }).collect(Collectors.toList());
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(AiMessage message) {
        ArrayList<AnthropicMessageContent> contents = new ArrayList<AnthropicMessageContent>();
        if (Utils.isNotNullOrBlank((String)message.text())) {
            contents.add(new AnthropicTextContent(message.text()));
        }
        if (message.hasToolExecutionRequests()) {
            List toolUseContents = message.toolExecutionRequests().stream().map(toolExecutionRequest -> AnthropicToolUseContent.builder().id(toolExecutionRequest.id()).name(toolExecutionRequest.name()).input((Map)Json.fromJson((String)toolExecutionRequest.arguments(), Map.class)).build()).collect(Collectors.toList());
            contents.addAll(toolUseContents);
        }
        return contents;
    }

    public static String toAnthropicSystemPrompt(List<ChatMessage> messages) {
        String systemPrompt = messages.stream().filter(message -> message instanceof SystemMessage).map(message -> ((SystemMessage)message).text()).collect(Collectors.joining("\n\n"));
        if (Utils.isNullOrBlank((String)systemPrompt)) {
            return null;
        }
        return systemPrompt;
    }

    public static AiMessage toAiMessage(List<AnthropicContent> contents) {
        String text = contents.stream().filter(content -> "text".equals(content.type)).map(content -> content.text).collect(Collectors.joining("\n"));
        List toolExecutionRequests = contents.stream().filter(content -> "tool_use".equals(content.type)).map(content -> ToolExecutionRequest.builder().id(content.id).name(content.name).arguments(Json.toJson(content.input)).build()).collect(Collectors.toList());
        if (Utils.isNotNullOrBlank((String)text) && !Utils.isNullOrEmpty(toolExecutionRequests)) {
            return new AiMessage(text, toolExecutionRequests);
        }
        if (!Utils.isNullOrEmpty(toolExecutionRequests)) {
            return AiMessage.from(toolExecutionRequests);
        }
        return AiMessage.from((String)text);
    }

    public static TokenUsage toTokenUsage(AnthropicUsage anthropicUsage) {
        if (anthropicUsage == null) {
            return null;
        }
        return new TokenUsage(anthropicUsage.inputTokens, anthropicUsage.outputTokens);
    }

    public static FinishReason toFinishReason(String anthropicStopReason) {
        if (anthropicStopReason == null) {
            return null;
        }
        switch (anthropicStopReason) {
            case "end_turn": {
                return FinishReason.STOP;
            }
            case "max_tokens": {
                return FinishReason.LENGTH;
            }
            case "stop_sequence": {
                return FinishReason.OTHER;
            }
            case "tool_use": {
                return FinishReason.TOOL_EXECUTION;
            }
        }
        return null;
    }

    public static List<AnthropicTool> toAnthropicTools(List<ToolSpecification> toolSpecifications) {
        if (toolSpecifications == null) {
            return null;
        }
        return toolSpecifications.stream().map(AnthropicMapper::toAnthropicTool).collect(Collectors.toList());
    }

    public static AnthropicTool toAnthropicTool(ToolSpecification toolSpecification) {
        ToolParameters parameters = toolSpecification.parameters();
        return AnthropicTool.builder().name(toolSpecification.name()).description(toolSpecification.description()).inputSchema(AnthropicToolSchema.builder().properties(parameters != null ? parameters.properties() : Collections.emptyMap()).required(parameters != null ? parameters.required() : Collections.emptyList()).build()).build();
    }
}

