/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.milvus;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.milvus.CollectionOperationsExecutor;
import dev.langchain4j.store.embedding.milvus.CollectionRequestBuilder;
import dev.langchain4j.store.embedding.milvus.Generator;
import dev.langchain4j.store.embedding.milvus.Mapper;
import dev.langchain4j.store.embedding.milvus.MilvusMetadataFilterMapper;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MilvusEmbeddingStore
implements EmbeddingStore<TextSegment> {
    static final String ID_FIELD_NAME = "id";
    static final String TEXT_FIELD_NAME = "text";
    static final String METADATA_FIELD_NAME = "metadata";
    static final String VECTOR_FIELD_NAME = "vector";
    private final MilvusServiceClient milvusClient;
    private final String collectionName;
    private final MetricType metricType;
    private final ConsistencyLevelEnum consistencyLevel;
    private final boolean retrieveEmbeddingsOnSearch;
    private final boolean autoFlushOnInsert;

    public MilvusEmbeddingStore(String host, Integer port, String collectionName, Integer dimension, IndexType indexType, MetricType metricType, String uri, String token, String username, String password, ConsistencyLevelEnum consistencyLevel, Boolean retrieveEmbeddingsOnSearch, Boolean autoFlushOnInsert, String databaseName) {
        ConnectParam.Builder connectBuilder = ConnectParam.newBuilder().withHost((String)Utils.getOrDefault((Object)host, (Object)"localhost")).withPort(((Integer)Utils.getOrDefault((Object)port, (Object)19530)).intValue()).withUri(uri).withToken(token).withAuthorization((String)Utils.getOrDefault((Object)username, (Object)""), (String)Utils.getOrDefault((Object)password, (Object)""));
        if (databaseName != null) {
            connectBuilder.withDatabaseName(databaseName);
        }
        this.milvusClient = new MilvusServiceClient(connectBuilder.build());
        this.collectionName = (String)Utils.getOrDefault((Object)collectionName, (Object)"default");
        this.metricType = (MetricType)Utils.getOrDefault((Object)metricType, (Object)MetricType.COSINE);
        this.consistencyLevel = (ConsistencyLevelEnum)Utils.getOrDefault((Object)consistencyLevel, (Object)ConsistencyLevelEnum.EVENTUALLY);
        this.retrieveEmbeddingsOnSearch = (Boolean)Utils.getOrDefault((Object)retrieveEmbeddingsOnSearch, (Object)false);
        this.autoFlushOnInsert = (Boolean)Utils.getOrDefault((Object)autoFlushOnInsert, (Object)false);
        if (!CollectionOperationsExecutor.hasCollection(this.milvusClient, this.collectionName)) {
            CollectionOperationsExecutor.createCollection(this.milvusClient, this.collectionName, (Integer)ValidationUtils.ensureNotNull((Object)dimension, (String)"dimension"));
            CollectionOperationsExecutor.createIndex(this.milvusClient, this.collectionName, (IndexType)Utils.getOrDefault((Object)indexType, (Object)IndexType.FLAT), this.metricType);
        }
        CollectionOperationsExecutor.loadCollectionInMemory(this.milvusClient, collectionName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void dropCollection(String collectionName) {
        CollectionOperationsExecutor.dropCollection(this.milvusClient, collectionName);
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = Generator.generateRandomIds(embeddings.size());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> embedded) {
        List<String> ids = Generator.generateRandomIds(embeddings.size());
        this.addAllInternal(ids, embeddings, embedded);
        return ids;
    }

    public EmbeddingSearchResult<TextSegment> search(EmbeddingSearchRequest embeddingSearchRequest) {
        SearchParam searchParam = CollectionRequestBuilder.buildSearchRequest(this.collectionName, embeddingSearchRequest.queryEmbedding().vectorAsList(), embeddingSearchRequest.filter(), embeddingSearchRequest.maxResults(), this.metricType, this.consistencyLevel);
        SearchResultsWrapper resultsWrapper = CollectionOperationsExecutor.search(this.milvusClient, searchParam);
        List<EmbeddingMatch<TextSegment>> matches = Mapper.toEmbeddingMatches(this.milvusClient, resultsWrapper, this.collectionName, this.consistencyLevel, this.retrieveEmbeddingsOnSearch);
        List result = matches.stream().filter(match -> match.score() >= embeddingSearchRequest.minScore()).collect(Collectors.toList());
        return new EmbeddingSearchResult(result);
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        fields.add(new InsertParam.Field(ID_FIELD_NAME, ids));
        fields.add(new InsertParam.Field(TEXT_FIELD_NAME, Mapper.toScalars(textSegments, ids.size())));
        fields.add(new InsertParam.Field(METADATA_FIELD_NAME, Mapper.toMetadataJsons(textSegments, ids.size())));
        fields.add(new InsertParam.Field(VECTOR_FIELD_NAME, Mapper.toVectors(embeddings)));
        CollectionOperationsExecutor.insert(this.milvusClient, this.collectionName, fields);
        if (this.autoFlushOnInsert) {
            CollectionOperationsExecutor.flush(this.milvusClient, this.collectionName);
        }
    }

    public void removeAll(Collection<String> ids) {
        ValidationUtils.ensureNotEmpty(ids, (String)"ids");
        CollectionOperationsExecutor.removeForVector(this.milvusClient, this.collectionName, String.format("%s in %s", ID_FIELD_NAME, MilvusMetadataFilterMapper.formatValues(ids)));
    }

    public void removeAll(Filter filter) {
        ValidationUtils.ensureNotNull((Object)filter, (String)"filter");
        CollectionOperationsExecutor.removeForVector(this.milvusClient, this.collectionName, MilvusMetadataFilterMapper.map(filter));
    }

    public void removeAll() {
        CollectionOperationsExecutor.removeForVector(this.milvusClient, this.collectionName, String.format("%s != \"\"", ID_FIELD_NAME));
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String collectionName;
        private Integer dimension;
        private IndexType indexType;
        private MetricType metricType;
        private String uri;
        private String token;
        private String username;
        private String password;
        private ConsistencyLevelEnum consistencyLevel;
        private Boolean retrieveEmbeddingsOnSearch;
        private String databaseName;
        private Boolean autoFlushOnInsert;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder indexType(IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder consistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder retrieveEmbeddingsOnSearch(Boolean retrieveEmbeddingsOnSearch) {
            this.retrieveEmbeddingsOnSearch = retrieveEmbeddingsOnSearch;
            return this;
        }

        public Builder autoFlushOnInsert(Boolean autoFlushOnInsert) {
            this.autoFlushOnInsert = autoFlushOnInsert;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public MilvusEmbeddingStore build() {
            return new MilvusEmbeddingStore(this.host, this.port, this.collectionName, this.dimension, this.indexType, this.metricType, this.uri, this.token, this.username, this.password, this.consistencyLevel, this.retrieveEmbeddingsOnSearch, this.autoFlushOnInsert, this.databaseName);
        }
    }
}

