/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import unirest.Headers;
import unirest.HttpResponse;
import unirest.RawResponse;
import unirest.UnirestParsingException;

abstract class BaseResponse<T>
implements HttpResponse<T> {
    private final Headers headers;
    private final String statusText;
    private final int statusCode;
    private Optional<UnirestParsingException> parsingerror = Optional.empty();

    protected BaseResponse(RawResponse response) {
        this.headers = response.getHeaders();
        this.statusCode = response.getStatus();
        this.statusText = response.getStatusText();
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public abstract InputStream getRawBody();

    @Override
    public abstract T getBody();

    @Override
    public Optional<UnirestParsingException> getParsingError() {
        return this.parsingerror;
    }

    @Override
    public <V> V mapBody(Function<T, V> func) {
        return func.apply(this.getBody());
    }

    @Override
    public <V> V mapRawBody(Function<InputStream, V> func) {
        return func.apply(this.getRawBody());
    }

    protected void setParsingException(String originalBody, RuntimeException e) {
        this.parsingerror = Optional.of(new UnirestParsingException(originalBody, e));
    }

    @Override
    public HttpResponse<T> ifSuccess(Consumer<HttpResponse<T>> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public HttpResponse<T> ifFailure(Consumer<HttpResponse<T>> consumer) {
        if (!this.isSuccess()) {
            consumer.accept(this);
        }
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.getStatus() >= 200 && this.getStatus() < 300 && !this.getParsingError().isPresent();
    }
}

