/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.nio.client.HttpAsyncClient;
import unirest.ApacheAsyncClient;
import unirest.ApacheClient;
import unirest.AsyncClient;
import unirest.Client;
import unirest.Headers;
import unirest.ObjectMapper;
import unirest.UnirestConfigException;
import unirest.UnirestException;

public class Config {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private Optional<Client> client = Optional.empty();
    private Optional<AsyncClient> asyncClient = Optional.empty();
    private Optional<ObjectMapper> objectMapper = Optional.empty();
    private List<HttpRequestInterceptor> interceptors = new ArrayList<HttpRequestInterceptor>();
    private Headers defaultHeaders;
    private HttpHost proxy;
    private CredentialsProvider proxyCreds;
    private int connectionTimeout;
    private int socketTimeout;
    private int maxTotal;
    private int maxPerRoute;
    private boolean followRedirects;
    private boolean cookieManagement;
    private boolean useSystemProperties;
    private String defaultResponseEncoding = StandardCharsets.UTF_8.name();
    private Function<Config, AsyncClient> asyncBuilder = ApacheAsyncClient::new;
    private Function<Config, Client> clientBuilder = ApacheClient::new;

    public Config() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.interceptors.clear();
        this.proxy = null;
        this.defaultHeaders = new Headers();
        this.connectionTimeout = 10000;
        this.socketTimeout = 60000;
        this.maxTotal = 200;
        this.maxPerRoute = 20;
        this.followRedirects = true;
        this.cookieManagement = true;
    }

    public Config httpClient(HttpClient httpClient) {
        this.client = Optional.of(new ApacheClient(httpClient, this, null, null));
        return this;
    }

    public Config httpClient(Client httpClient) {
        this.client = Optional.of(httpClient);
        return this;
    }

    public Config httpClient(Function<Config, Client> httpClient) {
        this.clientBuilder = httpClient;
        return this;
    }

    public Config asyncClient(HttpAsyncClient value) {
        this.asyncClient = Optional.of(new ApacheAsyncClient(value, this, null, null));
        return this;
    }

    public Config asyncClient(AsyncClient value) {
        this.asyncClient = Optional.of(value);
        return this;
    }

    public Config asyncClient(Function<Config, AsyncClient> asyncClientBuilder) {
        this.asyncBuilder = asyncClientBuilder;
        return this;
    }

    public Config proxy(HttpHost value) {
        this.validateClientsNotRunning();
        this.proxy = value;
        return this;
    }

    public Config proxy(String host, int port) {
        return this.proxy(new HttpHost(host, port));
    }

    public Config proxy(String host, int port, String username, String password) {
        this.proxyCreds = new BasicCredentialsProvider();
        this.proxyCreds.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(username, password));
        return this.proxy(new HttpHost(host, port));
    }

    public Config setObjectMapper(ObjectMapper om) {
        this.objectMapper = Optional.ofNullable(om);
        return this;
    }

    public Config connectTimeout(int inMillies) {
        this.validateClientsNotRunning();
        this.connectionTimeout = inMillies;
        return this;
    }

    public Config socketTimeout(int inMillies) {
        this.validateClientsNotRunning();
        this.socketTimeout = inMillies;
        return this;
    }

    public Config concurrency(int total, int perRoute) {
        this.validateClientsNotRunning();
        this.maxTotal = total;
        this.maxPerRoute = perRoute;
        return this;
    }

    public Config clearDefaultHeaders() {
        this.defaultHeaders.clear();
        return this;
    }

    public Config setDefaultHeader(String name, String value) {
        this.defaultHeaders.replace(name, value);
        return this;
    }

    public Config setDefaultHeader(String name, Supplier<String> value) {
        this.defaultHeaders.add(name, value);
        return this;
    }

    public Config addDefaultHeader(String name, String value) {
        this.defaultHeaders.add(name, value);
        return this;
    }

    public Config addInterceptor(HttpRequestInterceptor interceptor) {
        this.validateClientsNotRunning();
        this.interceptors.add(interceptor);
        return this;
    }

    public Config followRedirects(boolean enable) {
        this.validateClientsNotRunning();
        this.followRedirects = enable;
        return this;
    }

    public Config enableCookieManagement(boolean enable) {
        this.validateClientsNotRunning();
        this.cookieManagement = enable;
        return this;
    }

    public Config useSystemProperties(boolean value) {
        this.useSystemProperties = value;
        return this;
    }

    public Config setDefaultResponseEncoding(String value) {
        Objects.requireNonNull(value, "Encoding cannot be null");
        this.defaultResponseEncoding = value;
        return this;
    }

    public Headers getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public boolean isRunning() {
        return this.client.isPresent() || this.asyncClient.isPresent();
    }

    public Config reset() {
        this.shutDown(false);
        return this;
    }

    public void shutDown(boolean clearOptions) {
        List<Exception> ex = Stream.concat(this.client.map(Client::close).orElseGet(Stream::empty), this.asyncClient.map(AsyncClient::close).orElseGet(Stream::empty)).collect(Collectors.toList());
        this.client = Optional.empty();
        this.asyncClient = Optional.empty();
        if (clearOptions) {
            this.setDefaults();
        }
        if (!ex.isEmpty()) {
            throw new UnirestException(ex);
        }
    }

    public Client getClient() {
        if (!this.client.isPresent()) {
            this.buildClient();
        }
        return this.client.get();
    }

    private synchronized void buildClient() {
        if (!this.client.isPresent()) {
            this.client = Optional.of(this.clientBuilder.apply(this));
        }
    }

    public AsyncClient getAsyncClient() {
        if (!this.asyncClientIsReady()) {
            this.buildAsyncClient();
        }
        return this.asyncClient.get();
    }

    private boolean asyncClientIsReady() {
        return this.asyncClient.map(AsyncClient::isRunning).orElse(false);
    }

    private synchronized void buildAsyncClient() {
        if (!this.asyncClientIsReady()) {
            AsyncClient value = this.asyncBuilder.apply(this);
            this.verifyIsOn(value);
            this.asyncClient = Optional.of(value);
        }
    }

    private void verifyIsOn(AsyncClient value) {
        if (!value.isRunning()) {
            throw new UnirestConfigException("Attempted to get a new async client but it was not started. Please ensure it is");
        }
    }

    boolean getEnabledCookieManagement() {
        return this.cookieManagement;
    }

    boolean getFollowRedirects() {
        return this.followRedirects;
    }

    int getMaxConnections() {
        return this.maxTotal;
    }

    int getMaxPerRoutes() {
        return this.maxPerRoute;
    }

    int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    int getSocketTimeout() {
        return this.socketTimeout;
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper.orElseThrow(() -> new UnirestException("No Object Mapper Configured. Please config one with Unirest.config().setObjectMapper"));
    }

    private void validateClientsNotRunning() {
        if (this.client.isPresent() || this.asyncClient.isPresent()) {
            throw new UnirestConfigException("Http Clients are already build in order to build a new config execute Unirest.config().reset() before changing settings. \nThis should be done rarely.");
        }
    }

    List<HttpRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    HttpHost getProxy() {
        return this.proxy;
    }

    CredentialsProvider getProxyCreds() {
        return this.proxyCreds;
    }

    boolean useSystemProperties() {
        return this.useSystemProperties;
    }

    String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }
}

