/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

class FormPart
implements Comparable {
    private final String name;
    private final Object value;
    private final ContentType contentType;

    FormPart(String name, Object value, ContentType contentType) {
        this.name = name;
        this.value = value;
        this.contentType = contentType;
    }

    public Object getValue() {
        return this.value;
    }

    private ContentType getContentType() {
        if (this.contentType == null) {
            if (this.isFile()) {
                return ContentType.APPLICATION_OCTET_STREAM;
            }
            return ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8);
        }
        return this.contentType;
    }

    ContentBody toApachePart() {
        if (this.value instanceof File) {
            File file = (File)this.value;
            return new FileBody(file, this.getContentType(), file.getName());
        }
        if (this.value instanceof InputStreamBody) {
            return (ContentBody)this.value;
        }
        if (this.value instanceof ByteArrayBody) {
            return (ContentBody)this.value;
        }
        return new StringBody(this.value.toString(), this.getContentType());
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int compareTo(Object o) {
        if (o instanceof FormPart) {
            return this.getName().compareTo(((FormPart)o).getName());
        }
        return 0;
    }

    public boolean isFile() {
        return this.value instanceof File || this.value instanceof InputStreamBody || this.value instanceof ByteArrayBody;
    }
}

