/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HttpMethod {
    private static final Map<String, HttpMethod> REGISTRY = new HashMap<String, HttpMethod>();
    public static final HttpMethod GET = HttpMethod.valueOf("GET");
    public static final HttpMethod POST = HttpMethod.valueOf("POST");
    public static final HttpMethod PUT = HttpMethod.valueOf("PUT");
    public static final HttpMethod DELETE = HttpMethod.valueOf("DELETE");
    public static final HttpMethod PATCH = HttpMethod.valueOf("PATCH");
    public static final HttpMethod HEAD = HttpMethod.valueOf("HEAD");
    public static final HttpMethod OPTIONS = HttpMethod.valueOf("OPTIONS");
    public static final HttpMethod TRACE = HttpMethod.valueOf("TRACE");
    private final String name;

    private HttpMethod(String name) {
        this.name = name;
    }

    public static HttpMethod valueOf(String verb) {
        return REGISTRY.computeIfAbsent(verb, HttpMethod::new);
    }

    public Set<HttpMethod> all() {
        return new HashSet<HttpMethod>(REGISTRY.values());
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

