/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import unirest.BaseRequest;
import unirest.Body;
import unirest.Config;
import unirest.HttpMethod;
import unirest.JsonPatch;
import unirest.JsonPatchRequest;

class HttpRequestJsonPatch
extends BaseRequest<JsonPatchRequest>
implements JsonPatchRequest {
    private JsonPatch items = new JsonPatch();

    HttpRequestJsonPatch(Config config, String url) {
        super(config, HttpMethod.PATCH, url);
        this.header("Content-Type", "application/json-patch+json");
    }

    @Override
    public JsonPatchRequest add(String path, Object value) {
        this.items.add(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest remove(String path) {
        this.items.remove(path);
        return this;
    }

    @Override
    public JsonPatchRequest replace(String path, Object value) {
        this.items.replace(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest test(String path, Object value) {
        this.items.test(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest move(String from, String path) {
        this.items.move(from, path);
        return this;
    }

    @Override
    public JsonPatchRequest copy(String from, String path) {
        this.items.copy(from, path);
        return this;
    }

    @Override
    public Body getBody() {
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        BasicHttpEntity e = new BasicHttpEntity();
        e.setContent((InputStream)new ByteArrayInputStream(this.items.toString().getBytes()));
        return e;
    }
}

