/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import unirest.BaseRequest;
import unirest.Body;
import unirest.FormPart;
import unirest.HttpRequestBody;
import unirest.MultipartBody;
import unirest.Util;

class HttpRequestMultiPart
extends BaseRequest<MultipartBody>
implements MultipartBody {
    private List<FormPart> parameters = new ArrayList<FormPart>();
    private HttpMultipartMode mode = HttpMultipartMode.BROWSER_COMPATIBLE;
    private Charset charSet;

    HttpRequestMultiPart(HttpRequestBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
    }

    @Override
    public MultipartBody field(String name, String value) {
        this.addPart(name, value);
        return this;
    }

    @Override
    public MultipartBody field(String name, String value, String contentType) {
        this.addPart(name, value, this.tryParse(contentType));
        return this;
    }

    @Override
    public MultipartBody field(String name, Collection<?> collection) {
        for (Object current : collection) {
            this.addPart(name, current, null);
        }
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream value, ContentType contentType) {
        this.addPart(name, new InputStreamBody(value, contentType), contentType);
        return this;
    }

    @Override
    public MultipartBody field(String name, File file) {
        this.addPart(name, file);
        return this;
    }

    @Override
    public MultipartBody field(String name, File file, String contentType) {
        this.addPart(name, file, this.tryParse(contentType));
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream stream, ContentType contentType, String fileName) {
        this.addPart(name, new InputStreamBody(stream, contentType, fileName), contentType);
        return this;
    }

    @Override
    public MultipartBody field(String name, InputStream stream, String fileName) {
        this.addPart(name, new InputStreamBody(stream, ContentType.APPLICATION_OCTET_STREAM, fileName), ContentType.APPLICATION_OCTET_STREAM);
        return this;
    }

    @Override
    public MultipartBody field(String name, byte[] bytes, ContentType contentType, String fileName) {
        this.addPart(name, new ByteArrayBody(bytes, contentType, fileName), contentType);
        return this;
    }

    @Override
    public MultipartBody field(String name, byte[] bytes, String fileName) {
        this.addPart(name, new ByteArrayBody(bytes, ContentType.APPLICATION_OCTET_STREAM, fileName), ContentType.APPLICATION_OCTET_STREAM);
        return this;
    }

    @Override
    public MultipartBody charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public MultipartBody contentType(String mimeType) {
        this.header("Content-Type", mimeType);
        return this;
    }

    @Override
    public MultipartBody mode(String value) {
        this.mode = HttpMultipartMode.valueOf((String)value);
        return this;
    }

    @Override
    public MultipartBody mode(HttpMultipartMode value) {
        this.mode = value;
        return this;
    }

    public MultipartBody fields(Map<String, Object> fields) {
        if (fields != null) {
            for (Map.Entry<String, Object> param : fields.entrySet()) {
                if (param.getValue() instanceof File) {
                    this.field(param.getKey(), (File)param.getValue());
                    continue;
                }
                this.field(param.getKey(), Util.nullToEmpty(param.getValue()));
            }
        }
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        if (this.parameters.stream().anyMatch(FormPart::isFile)) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(this.charSet);
            builder.setMode(this.mode);
            for (FormPart key : this.parameters) {
                builder.addPart(key.getName(), key.toApachePart());
            }
            return builder.build();
        }
        return new UrlEncodedFormEntity(Util.getList(this.parameters), this.charSet);
    }

    @Override
    public Body getBody() {
        return this;
    }

    private void addPart(String name, Object value, ContentType type) {
        this.parameters.add(new FormPart(name, value, type));
        Collections.sort(this.parameters);
    }

    private void addPart(String name, Object value) {
        this.addPart(name, value, null);
    }

    private ContentType tryParse(String contentType) {
        if (contentType != null && contentType.length() > 0) {
            return ContentType.parse((String)contentType);
        }
        return null;
    }
}

