/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import unirest.BaseRequest;
import unirest.Body;
import unirest.HttpRequestBody;
import unirest.JsonNode;
import unirest.RequestBodyEntity;

class HttpRequestUniBody
extends BaseRequest<RequestBodyEntity>
implements RequestBodyEntity {
    private Supplier<HttpEntity> body = () -> new StringEntity("", StandardCharsets.UTF_8);
    private Charset charSet;

    HttpRequestUniBody(HttpRequestBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
    }

    @Override
    public RequestBodyEntity body(byte[] bodyBytes) {
        this.body = () -> new ByteArrayEntity(bodyBytes);
        return this;
    }

    @Override
    public RequestBodyEntity body(String bodyAsString) {
        this.body = () -> new StringEntity(bodyAsString, this.charSet);
        return this;
    }

    @Override
    public RequestBodyEntity body(JsonNode jsonBody) {
        return this.body(jsonBody.toString());
    }

    @Override
    public RequestBodyEntity charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        return this.body.get();
    }

    @Override
    public Body getBody() {
        return this;
    }
}

