/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import unirest.JsonPatchItem;
import unirest.JsonPatchOperation;

public class JsonPatch {
    private List<JsonPatchItem> items = new ArrayList<JsonPatchItem>();

    public JsonPatch() {
    }

    public JsonPatch(String fromString) {
        for (Object row : new JSONArray(fromString)) {
            if (!(row instanceof JSONObject)) continue;
            this.items.add(new JsonPatchItem((JSONObject)row));
        }
    }

    public void add(String path, Object value) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.add, path, value));
    }

    public void remove(String path) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.remove, path));
    }

    public void replace(String path, Object value) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.replace, path, value));
    }

    public void test(String path, Object value) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.test, path, value));
    }

    public void move(String from, String path) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.move, path, from));
    }

    public void copy(String from, String path) {
        this.items.add(new JsonPatchItem(JsonPatchOperation.copy, path, from));
    }

    public String toString() {
        JSONArray a = new JSONArray();
        this.items.forEach(i -> a.put((Object)new JSONObject(i.toString())));
        return a.toString();
    }

    public Iterable<JsonPatchItem> getOperations() {
        return Collections.unmodifiableList(this.items);
    }
}

