/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import unirest.BaseResponse;
import unirest.JsonNode;
import unirest.RawResponse;

public class JsonResponse
extends BaseResponse<JsonNode> {
    private JsonNode node;
    private InputStream errorStream;

    protected JsonResponse(RawResponse response) {
        super(response);
        this.node = this.getNode(response);
    }

    private JsonNode getNode(RawResponse response) {
        if (Objects.isNull(response) || !response.hasContent()) {
            return new JsonNode(null);
        }
        String json = response.getContentAsString();
        return this.toJsonNode(json);
    }

    private JsonNode toJsonNode(String json) {
        try {
            return new JsonNode(json);
        }
        catch (RuntimeException e) {
            super.setParsingException(json, e);
            this.errorStream = new ByteArrayInputStream(json.getBytes());
            return null;
        }
    }

    @Override
    public InputStream getRawBody() {
        if (this.errorStream != null) {
            return this.errorStream;
        }
        return new ByteArrayInputStream(this.node.toString().getBytes());
    }

    @Override
    public JsonNode getBody() {
        return this.node;
    }
}

