/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import unirest.BaseResponse;
import unirest.GenericType;
import unirest.ObjectMapper;
import unirest.RawResponse;

class ObjectResponse<T>
extends BaseResponse<T> {
    private final T body;
    private final ObjectMapper om;

    ObjectResponse(ObjectMapper om, RawResponse response, Class<? extends T> to) {
        super(response);
        this.om = om;
        this.body = this.readBody(response).map(s -> this.getBody((String)s, e -> om.readValue((String)e, to))).orElse(null);
    }

    ObjectResponse(ObjectMapper om, RawResponse response, GenericType<? extends T> to) {
        super(response);
        this.om = om;
        this.body = this.readBody(response).map(s -> this.getBody((String)s, e -> om.readValue((String)e, to))).orElse(null);
    }

    private Optional<String> readBody(RawResponse response) {
        if (!response.hasContent()) {
            return Optional.empty();
        }
        return Optional.of(response.getContentAsString());
    }

    private T getBody(String b, Function<String, T> func) {
        try {
            return func.apply(b);
        }
        catch (RuntimeException e) {
            this.setParsingException(b, e);
            return null;
        }
    }

    @Override
    public InputStream getRawBody() {
        if (this.body == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.om.writeValue(this.body).getBytes());
    }

    @Override
    public T getBody() {
        return this.body;
    }
}

