/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import unirest.UnirestException;
import unirest.Util;

class Path {
    private String url;

    Path(String url) {
        this.url = url;
    }

    public void param(String name, String value) {
        Matcher matcher = Pattern.compile("\\{" + name + "\\}").matcher(this.url);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 0) {
            throw new UnirestException("Can't find route parameter name \"" + name + "\"");
        }
        this.url = this.url.replaceAll("\\{" + name + "\\}", Util.encode(value));
    }

    public void queryString(String name, Collection<?> value) {
        for (Object cur : value) {
            this.queryString(name, cur);
        }
    }

    public void queryString(String name, Object value) {
        StringBuilder queryString = new StringBuilder();
        if (this.url.contains("?")) {
            queryString.append("&");
        } else {
            queryString.append("?");
        }
        try {
            queryString.append(URLEncoder.encode(name));
            if (value != null) {
                queryString.append("=").append(URLEncoder.encode(value.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
        this.url = this.url + queryString.toString();
    }

    public void queryString(Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                if (param.getValue() instanceof String || param.getValue() instanceof Number || param.getValue() instanceof Boolean || param.getValue() == null) {
                    this.queryString(param.getKey(), param.getValue());
                    continue;
                }
                throw new UnirestException("Parameter \"" + param.getKey() + "\" can't be sent with a GET request because of type: " + param.getValue().getClass().getName());
            }
        }
    }

    public String toString() {
        return this.url;
    }
}

