/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NByteArrayEntity;
import unirest.ApacheRequestWithBody;
import unirest.Header;
import unirest.HttpDeleteWithBody;
import unirest.HttpMethod;
import unirest.HttpPatchWithBody;
import unirest.HttpRequest;
import unirest.UnirestException;

class RequestPrep {
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACCEPT_ENCODING_HEADER = "accept-encoding";
    private static final String USER_AGENT_HEADER = "user-agent";
    private static final String USER_AGENT = "unirest-java/3.0.00";
    private static final Map<HttpMethod, Function<String, HttpRequestBase>> FACTORIES = new HashMap<HttpMethod, Function<String, HttpRequestBase>>();
    private final HttpRequest request;
    private final boolean async;

    RequestPrep(HttpRequest request, boolean async) {
        this.request = request;
        this.async = async;
    }

    HttpRequestBase prepare() {
        HttpRequestBase reqObj = this.getHttpRequestBase();
        this.setBody(reqObj);
        return reqObj;
    }

    private HttpRequestBase getHttpRequestBase() {
        if (!this.request.getHeaders().containsKey(USER_AGENT_HEADER)) {
            this.request.header(USER_AGENT_HEADER, USER_AGENT);
        }
        if (!this.request.getHeaders().containsKey(ACCEPT_ENCODING_HEADER)) {
            this.request.header(ACCEPT_ENCODING_HEADER, "gzip");
        }
        try {
            String url = this.request.getUrl();
            HttpRequestBase reqObj = (HttpRequestBase)FACTORIES.computeIfAbsent(this.request.getHttpMethod(), this::register).apply(url);
            this.request.getHeaders().all().stream().map(this::toEntries).forEach(arg_0 -> ((HttpRequestBase)reqObj).addHeader(arg_0));
            return reqObj;
        }
        catch (RuntimeException e) {
            throw new UnirestException(e);
        }
    }

    private Function<String, HttpRequestBase> register(HttpMethod method) {
        return u -> new ApacheRequestWithBody(method, (String)u);
    }

    private org.apache.http.Header toEntries(Header k) {
        return new BasicHeader(k.getName(), k.getValue());
    }

    private void setBody(HttpRequestBase reqObj) {
        if (this.request.getHttpMethod() != HttpMethod.GET && this.request.getHttpMethod() != HttpMethod.HEAD && this.request.getBody() != null) {
            HttpEntity entity = this.request.getBody().getEntity();
            if (this.async) {
                if (reqObj.getHeaders(CONTENT_TYPE) == null || reqObj.getHeaders(CONTENT_TYPE).length == 0) {
                    reqObj.setHeader(entity.getContentType());
                }
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)output);
                    NByteArrayEntity en = new NByteArrayEntity(output.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity((HttpEntity)en);
                }
                catch (IOException e) {
                    throw new UnirestException(e);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
    }

    static {
        FACTORIES.put(HttpMethod.GET, HttpGet::new);
        FACTORIES.put(HttpMethod.POST, HttpPost::new);
        FACTORIES.put(HttpMethod.PUT, HttpPut::new);
        FACTORIES.put(HttpMethod.DELETE, HttpDeleteWithBody::new);
        FACTORIES.put(HttpMethod.PATCH, HttpPatchWithBody::new);
        FACTORIES.put(HttpMethod.OPTIONS, HttpOptions::new);
        FACTORIES.put(HttpMethod.HEAD, HttpHead::new);
    }
}

