/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import unirest.Config;
import unirest.GetRequest;
import unirest.HttpMethod;
import unirest.HttpRequestBody;
import unirest.HttpRequestJsonPatch;
import unirest.HttpRequestNoBody;
import unirest.HttpRequestWithBody;
import unirest.JsonPatchRequest;

public class UnirestInstance
implements AutoCloseable {
    private final Config config;

    public UnirestInstance(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    public void shutDown() {
        this.shutDown(true);
    }

    public void shutDown(boolean clearOptions) {
        this.config.shutDown(clearOptions);
    }

    public GetRequest get(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.GET, url);
    }

    public GetRequest head(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.HEAD, url);
    }

    public GetRequest options(String url) {
        return new HttpRequestNoBody(this.config, HttpMethod.OPTIONS, url);
    }

    public HttpRequestWithBody post(String url) {
        return new HttpRequestBody(this.config, HttpMethod.POST, url);
    }

    public HttpRequestWithBody delete(String url) {
        return new HttpRequestBody(this.config, HttpMethod.DELETE, url);
    }

    public HttpRequestWithBody patch(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PATCH, url);
    }

    public HttpRequestWithBody put(String url) {
        return new HttpRequestBody(this.config, HttpMethod.PUT, url);
    }

    public JsonPatchRequest jsonPatch(String url) {
        return new HttpRequestJsonPatch(this.config, url);
    }

    public HttpRequestWithBody request(String method, String url) {
        return new HttpRequestBody(this.config, HttpMethod.valueOf(method), url);
    }

    public boolean isRunning() {
        return this.config.isRunning();
    }

    @Override
    public void close() {
        this.shutDown(true);
    }
}

