/*
 * Decompiled with CFR 0.152.
 */
package unirest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import unirest.FormPart;
import unirest.UnirestException;

class Util {
    Util() {
    }

    static <T> Stream<T> stream(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    static <T, M extends T> Optional<M> tryCast(T original, Class<M> too) {
        if (original != null && too.isAssignableFrom(original.getClass())) {
            return Optional.of(original);
        }
        return Optional.empty();
    }

    static <T> Optional<Exception> tryDo(T c, ExConsumer<T> consumer) {
        try {
            if (Objects.nonNull(c)) {
                consumer.accept(c);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    static String nullToEmpty(Object v) {
        if (v == null) {
            return "";
        }
        return String.valueOf(v);
    }

    static String encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
    }

    static List<NameValuePair> getList(Collection<FormPart> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (FormPart entry : parameters) {
            result.add((NameValuePair)new BasicNameValuePair(entry.getName(), entry.getValue().toString()));
        }
        return result;
    }

    static Stream<Exception> collectExceptions(Optional<Exception> ... ex) {
        return Stream.of(ex).flatMap(Util::stream);
    }

    public static InputStream emptyStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    @FunctionalInterface
    public static interface ExConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

