/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.http;

import io.github.openunirest.http.BodyData;
import io.github.openunirest.http.Headers;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import org.apache.http.StatusLine;

public class HttpResponse<T> {
    private final Headers headers;
    private final int statusCode;
    private final String statusText;
    private InputStream rawBody;
    private Optional<RuntimeException> parsingError = Optional.empty();
    private T body;

    private HttpResponse(org.apache.http.HttpResponse response) {
        this.headers = new Headers(response.getAllHeaders());
        StatusLine statusLine = response.getStatusLine();
        this.statusCode = statusLine.getStatusCode();
        this.statusText = statusLine.getReasonPhrase();
    }

    public HttpResponse(org.apache.http.HttpResponse response, BodyData<T> data) {
        this(response);
        this.rawBody = data.getRawInput();
        this.body = data.getTransFormedBody();
        this.parsingError = Optional.ofNullable(data.getParseEx());
    }

    public HttpResponse(org.apache.http.HttpResponse response, T body, InputStream is) {
        this(response);
        this.body = body;
        this.rawBody = is;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public T getBody() {
        return this.body;
    }

    public Optional<RuntimeException> getParsingError() {
        return this.parsingError;
    }

    public <V> V mapBody(Function<T, V> func) {
        return func.apply(this.body);
    }

    public <V> V mapRawBody(Function<InputStream, V> func) {
        return func.apply(this.rawBody);
    }
}

