/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.http;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonNode {
    private JSONObject jsonObject;
    private JSONArray jsonArray;
    private boolean array;

    public JsonNode(String json) {
        if (json == null || "".equals(json.trim())) {
            this.jsonObject = new JSONObject();
        } else {
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                try {
                    this.jsonArray = new JSONArray(json);
                    this.array = true;
                }
                catch (JSONException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public JSONObject getObject() {
        return this.jsonObject;
    }

    public JSONArray getArray() {
        JSONArray result = this.jsonArray;
        if (!this.array) {
            result = new JSONArray();
            result.put((Object)this.jsonObject);
        }
        return result;
    }

    public boolean isArray() {
        return this.array;
    }

    public String toString() {
        if (this.isArray()) {
            return this.jsonArray.toString();
        }
        return this.jsonObject.toString();
    }
}

