/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.http;

import io.github.openunirest.http.HttpMethod;
import io.github.openunirest.http.ObjectMapper;
import io.github.openunirest.http.async.utils.AsyncIdleConnectionMonitorThread;
import io.github.openunirest.http.exceptions.UnirestException;
import io.github.openunirest.http.options.Option;
import io.github.openunirest.http.options.Options;
import io.github.openunirest.http.utils.SyncIdleConnectionMonitorThread;
import io.github.openunirest.request.GetRequest;
import io.github.openunirest.request.HttpRequestWithBody;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class Unirest {
    public static void setHttpClient(HttpClient httpClient) {
        Options.setOption(Option.HTTPCLIENT, httpClient);
        Options.customClientSet();
    }

    public static void setAsyncHttpClient(CloseableHttpAsyncClient asyncHttpClient) {
        Options.setOption(Option.ASYNCHTTPCLIENT, asyncHttpClient);
        Options.customClientSet();
    }

    public static void setProxy(HttpHost proxy) {
        Options.setOption(Option.PROXY, proxy);
        Options.refresh();
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Options.setOption(Option.OBJECT_MAPPER, objectMapper);
        Options.refresh();
    }

    public static void setTimeouts(int connectionTimeout, int socketTimeout) {
        Options.setOption(Option.CONNECTION_TIMEOUT, connectionTimeout);
        Options.setOption(Option.SOCKET_TIMEOUT, socketTimeout);
        Options.refresh();
    }

    public static void setConcurrency(int maxTotal, int maxPerRoute) {
        Options.setOption(Option.MAX_TOTAL, maxTotal);
        Options.setOption(Option.MAX_PER_ROUTE, maxPerRoute);
        Options.refresh();
    }

    public static void clearDefaultHeaders() {
        Options.setOption(Option.DEFAULT_HEADERS, null);
    }

    public static void setDefaultHeader(String name, String value) {
        HashMap headers = Options.getOption(Option.DEFAULT_HEADERS);
        if (headers == null) {
            headers = new HashMap();
        }
        ((Map)headers).put(name, value);
        Options.setOption(Option.DEFAULT_HEADERS, headers);
    }

    public static void shutdown() {
        Options.tryGet(Option.HTTPCLIENT, CloseableHttpClient.class).ifPresent(Unirest::closeIt);
        Options.tryGet(Option.SYNC_MONITOR, SyncIdleConnectionMonitorThread.class).ifPresent(Thread::interrupt);
        Options.tryGet(Option.ASYNCHTTPCLIENT, CloseableHttpAsyncClient.class).filter(CloseableHttpAsyncClient::isRunning).ifPresent(Unirest::closeIt);
        Options.tryGet(Option.ASYNC_MONITOR, AsyncIdleConnectionMonitorThread.class).ifPresent(Thread::interrupt);
    }

    private static void closeIt(Closeable c) {
        try {
            c.close();
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    public static GetRequest get(String url) {
        return new GetRequest(HttpMethod.GET, url);
    }

    public static GetRequest head(String url) {
        return new GetRequest(HttpMethod.HEAD, url);
    }

    public static HttpRequestWithBody options(String url) {
        return new HttpRequestWithBody(HttpMethod.OPTIONS, url);
    }

    public static HttpRequestWithBody post(String url) {
        return new HttpRequestWithBody(HttpMethod.POST, url);
    }

    public static HttpRequestWithBody delete(String url) {
        return new HttpRequestWithBody(HttpMethod.DELETE, url);
    }

    public static HttpRequestWithBody patch(String url) {
        return new HttpRequestWithBody(HttpMethod.PATCH, url);
    }

    public static HttpRequestWithBody put(String url) {
        return new HttpRequestWithBody(HttpMethod.PUT, url);
    }
}

