/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.http.options;

import io.github.openunirest.http.Unirest;
import io.github.openunirest.http.async.utils.AsyncIdleConnectionMonitorThread;
import io.github.openunirest.http.options.Option;
import io.github.openunirest.http.utils.SyncIdleConnectionMonitorThread;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class Options {
    public static final int MAX_TOTAL = 200;
    public static final int MAX_PER_ROUTE = 20;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int SOCKET_TIMEOUT = 60000;
    private static Map<Option, Object> options = new HashMap<Option, Object>();
    private static boolean customClientSet = false;
    private static PoolingHttpClientConnectionManager syncConnectionManager;
    private static SyncIdleConnectionMonitorThread defaultSyncMonitor;

    public static void customClientSet() {
        customClientSet = true;
    }

    public static void setOption(Option option, Object value) {
        Options.validateOption(option);
        options.put(option, value);
    }

    private static void validateOption(Option option) {
        if ((option == Option.CONNECTION_TIMEOUT || option == Option.SOCKET_TIMEOUT) && customClientSet) {
            throw new RuntimeException("You can't set custom timeouts when providing custom client implementations. Set the timeouts directly in your custom client configuration instead.");
        }
    }

    public static Object getOption(Option option) {
        return options.get((Object)option);
    }

    private static <T> T getOptionOrDefault(Option option, T defaultValue) {
        return (T)options.computeIfAbsent(option, o -> defaultValue);
    }

    private static void createMonitors() {
        syncConnectionManager = new PoolingHttpClientConnectionManager();
        defaultSyncMonitor = new SyncIdleConnectionMonitorThread((HttpClientConnectionManager)syncConnectionManager);
        defaultSyncMonitor.start();
        Options.setOption(Option.SYNC_MONITOR, defaultSyncMonitor);
    }

    public static void refresh() {
        PoolingNHttpClientConnectionManager asyncConnectionManager;
        RequestConfig clientConfig = Options.getRequestConfig();
        Integer maxTotal = Options.getOptionOrDefault(Option.MAX_TOTAL, 200);
        Integer maxPerRoute = Options.getOptionOrDefault(Option.MAX_PER_ROUTE, 20);
        syncConnectionManager.setMaxTotal(maxTotal.intValue());
        syncConnectionManager.setDefaultMaxPerRoute(maxPerRoute.intValue());
        CloseableHttpClient build = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).useSystemProperties().build();
        Options.setOption(Option.HTTPCLIENT, build);
        try {
            asyncConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor());
            asyncConnectionManager.setMaxTotal(maxTotal.intValue());
            asyncConnectionManager.setDefaultMaxPerRoute(maxPerRoute.intValue());
        }
        catch (IOReactorException e) {
            throw new RuntimeException(e);
        }
        CloseableHttpAsyncClient asyncClient = HttpAsyncClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((NHttpClientConnectionManager)asyncConnectionManager).useSystemProperties().build();
        Options.setOption(Option.ASYNCHTTPCLIENT, asyncClient);
        Options.setOption(Option.ASYNC_MONITOR, new AsyncIdleConnectionMonitorThread(asyncConnectionManager));
    }

    private static RequestConfig getRequestConfig() {
        Integer connectionTimeout = Options.getOptionOrDefault(Option.CONNECTION_TIMEOUT, 10000);
        Integer socketTimeout = Options.getOptionOrDefault(Option.SOCKET_TIMEOUT, 60000);
        HttpHost proxy = (HttpHost)Options.getOption(Option.PROXY);
        return RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).setConnectionRequestTimeout(socketTimeout.intValue()).setProxy(proxy).build();
    }

    public static void init() {
        Unirest.shutdown();
        Options.createMonitors();
        Options.setDefaults();
        Options.refresh();
    }

    private static void setDefaults() {
        customClientSet = false;
        options.clear();
        Options.setOption(Option.CONNECTION_TIMEOUT, 10000);
        Options.setOption(Option.SOCKET_TIMEOUT, 60000);
        Options.setOption(Option.MAX_TOTAL, 200);
        Options.setOption(Option.MAX_PER_ROUTE, 20);
        Options.setOption(Option.SYNC_MONITOR, defaultSyncMonitor);
    }

    public static <T> Optional<T> tryGet(Option option, Class<T> as) {
        Object o = Options.getOption(option);
        if (Objects.isNull(o) || !as.isAssignableFrom(o.getClass())) {
            return Optional.empty();
        }
        return Optional.of(o);
    }

    public static void removeOption(Option objectMapper) {
        options.remove((Object)objectMapper);
    }

    static {
        Options.createMonitors();
        Options.setDefaults();
        Options.refresh();
    }
}

