/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.http.utils;

import io.github.openunirest.http.exceptions.UnirestException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public class ResponseUtils {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    public static boolean isGzipped(Header contentEncoding) {
        String value;
        return contentEncoding != null && (value = contentEncoding.getValue()) != null && "gzip".equals(value.toLowerCase().trim());
    }

    public static String getCharSet(HttpEntity responseEntity) {
        String responseCharset;
        Header contentType = responseEntity.getContentType();
        if (contentType != null && (responseCharset = ResponseUtils.getCharsetFromContentType(contentType.getValue())) != null && !responseCharset.trim().equals("")) {
            return responseCharset;
        }
        return "UTF-8";
    }

    public static byte[] getRawBody(HttpEntity responseEntity) {
        try {
            InputStream is = responseEntity.getContent();
            if (ResponseUtils.isGzipped(responseEntity.getContentEncoding())) {
                is = new GZIPInputStream(responseEntity.getContent());
            }
            byte[] byArray = ResponseUtils.getBytes(is);
            return byArray;
        }
        catch (IOException e2) {
            throw new UnirestException(e2);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)responseEntity);
        }
    }
}

