/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.request;

import io.github.openunirest.http.HttpResponse;
import io.github.openunirest.http.JsonNode;
import io.github.openunirest.http.async.Callback;
import io.github.openunirest.http.exceptions.UnirestException;
import io.github.openunirest.request.HttpClientHelper;
import io.github.openunirest.request.HttpRequest;
import io.github.openunirest.request.ResponseBuilder;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

public abstract class BaseRequest {
    protected static final String UTF_8 = "UTF-8";
    private final ResponseBuilder builder = new ResponseBuilder();
    protected HttpRequest httpRequest;

    protected BaseRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    protected BaseRequest() {
    }

    public HttpResponse<String> asString() throws UnirestException {
        return HttpClientHelper.request(this.httpRequest, this.builder::asString);
    }

    public CompletableFuture<HttpResponse<String>> asStringAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asString);
    }

    public CompletableFuture<HttpResponse<String>> asStringAsync(Callback<String> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asString, callback);
    }

    public HttpResponse<JsonNode> asJson() throws UnirestException {
        return HttpClientHelper.request(this.httpRequest, this.builder::asJson);
    }

    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asJson);
    }

    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync(Callback<JsonNode> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asJson, callback);
    }

    public <T> HttpResponse<T> asObject(Class<? extends T> responseClass) throws UnirestException {
        return HttpClientHelper.request(this.httpRequest, r -> this.builder.asObject((org.apache.http.HttpResponse)r, responseClass));
    }

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> responseClass) {
        return HttpClientHelper.requestAsync(this.httpRequest, r -> this.builder.asObject((org.apache.http.HttpResponse)r, responseClass));
    }

    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> responseClass, Callback<T> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, r -> this.builder.asObject((org.apache.http.HttpResponse)r, responseClass), callback);
    }

    public HttpResponse<InputStream> asBinary() throws UnirestException {
        return HttpClientHelper.request(this.httpRequest, this.builder::asBinary);
    }

    public CompletableFuture<HttpResponse<InputStream>> asBinaryAsync() {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asBinary);
    }

    public CompletableFuture<HttpResponse<InputStream>> asBinaryAsync(Callback<InputStream> callback) {
        return HttpClientHelper.requestAsync(this.httpRequest, this.builder::asBinary, callback);
    }
}

