/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.request;

import io.github.openunirest.http.HttpMethod;
import io.github.openunirest.http.options.Option;
import io.github.openunirest.http.options.Options;
import io.github.openunirest.request.HttpDeleteWithBody;
import io.github.openunirest.request.HttpPatchWithBody;
import io.github.openunirest.request.HttpRequest;
import io.github.openunirest.request.UriFormatter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.nio.entity.NByteArrayEntity;

class RequestPrep {
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACCEPT_ENCODING_HEADER = "accept-encoding";
    private static final String USER_AGENT_HEADER = "user-agent";
    private static final String USER_AGENT = "unirest-java/1.3.11";
    private static final UriFormatter URI_FORMATTER = new UriFormatter();

    RequestPrep() {
    }

    public static HttpRequestBase prepareRequest(HttpRequest request, boolean async) {
        RequestPrep.setDefaultHeaders(request);
        if (!request.getHeaders().containsKey(USER_AGENT_HEADER)) {
            request.header(USER_AGENT_HEADER, USER_AGENT);
        }
        if (!request.getHeaders().containsKey(ACCEPT_ENCODING_HEADER)) {
            request.header(ACCEPT_ENCODING_HEADER, "gzip");
        }
        HttpRequestBase reqObj = RequestPrep.getHttpRequest(request);
        RequestPrep.setRequestHeaders(request, reqObj);
        RequestPrep.setBody(request, async, reqObj);
        return reqObj;
    }

    private static void setBody(HttpRequest request, boolean async, HttpRequestBase reqObj) {
        if (request.getHttpMethod() != HttpMethod.GET && request.getHttpMethod() != HttpMethod.HEAD && request.getBody() != null) {
            HttpEntity entity = request.getBody().getEntity();
            if (async) {
                if (reqObj.getHeaders(CONTENT_TYPE) == null || reqObj.getHeaders(CONTENT_TYPE).length == 0) {
                    reqObj.setHeader(entity.getContentType());
                }
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    entity.writeTo((OutputStream)output);
                    NByteArrayEntity en = new NByteArrayEntity(output.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity((HttpEntity)en);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
    }

    private static void setRequestHeaders(HttpRequest request, HttpRequestBase reqObj) {
        Set<Map.Entry<String, List<String>>> entrySet = request.getHeaders().entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> values = entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                reqObj.addHeader(entry.getKey(), value);
            }
        }
    }

    private static void setDefaultHeaders(HttpRequest request) {
        Object defaultHeaders = Options.getOption(Option.DEFAULT_HEADERS);
        if (defaultHeaders != null) {
            Set entrySet = ((Map)defaultHeaders).entrySet();
            for (Map.Entry entry : entrySet) {
                request.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static HttpRequestBase getHttpRequest(HttpRequest request) {
        Object reqObj = null;
        String urlToRequest = URI_FORMATTER.apply(request);
        switch (request.getHttpMethod()) {
            case GET: {
                reqObj = new HttpGet(urlToRequest);
                break;
            }
            case POST: {
                reqObj = new HttpPost(urlToRequest);
                break;
            }
            case PUT: {
                reqObj = new HttpPut(urlToRequest);
                break;
            }
            case DELETE: {
                reqObj = new HttpDeleteWithBody(urlToRequest);
                break;
            }
            case PATCH: {
                reqObj = new HttpPatchWithBody(urlToRequest);
                break;
            }
            case OPTIONS: {
                reqObj = new HttpOptions(urlToRequest);
                break;
            }
            case HEAD: {
                reqObj = new HttpHead(urlToRequest);
            }
        }
        return reqObj;
    }
}

