/*
 * Decompiled with CFR 0.152.
 */
package io.github.openunirest.request;

import io.github.openunirest.http.BodyData;
import io.github.openunirest.http.HttpResponse;
import io.github.openunirest.http.JsonNode;
import io.github.openunirest.http.ObjectMapper;
import io.github.openunirest.http.exceptions.UnirestException;
import io.github.openunirest.http.options.Option;
import io.github.openunirest.http.options.Options;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

class ResponseBuilder {
    ResponseBuilder() {
    }

    public HttpResponse<JsonNode> asJson(org.apache.http.HttpResponse response) {
        return new HttpResponse<JsonNode>(response, BodyData.from(response.getEntity(), b -> this.toJson((BodyData<JsonNode>)b)));
    }

    public HttpResponse<InputStream> asBinary(org.apache.http.HttpResponse response) {
        return new HttpResponse<InputStream>(response, BodyData.from(response.getEntity(), BodyData::getRawInput));
    }

    public <T> HttpResponse<T> asObject(org.apache.http.HttpResponse response, Class<? extends T> aClass) {
        return new HttpResponse<Object>(response, BodyData.from(response.getEntity(), b -> this.toObject((BodyData)b, aClass)));
    }

    public HttpResponse<String> asString(org.apache.http.HttpResponse response) {
        return new HttpResponse<String>(response, BodyData.from(response.getEntity(), this::toString));
    }

    private <T> T toObject(BodyData<T> b, Class<? extends T> aClass) {
        ObjectMapper o = this.getObjectMapper();
        return o.readValue(this.toString(b), aClass);
    }

    private String toString(BodyData b) {
        try {
            return new String(b.getRawBytes(), b.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new ParsingException(e);
        }
    }

    private JsonNode toJson(BodyData<JsonNode> b) {
        String jsonString = this.toString(b);
        return new JsonNode(jsonString);
    }

    private ObjectMapper getObjectMapper() {
        return Options.tryGet(Option.OBJECT_MAPPER, ObjectMapper.class).orElseThrow(() -> new UnirestException("No Object Mapper Configured. Please configure one with Unirest.setObjectMapper"));
    }

    public static class ParsingException
    extends RuntimeException {
        public ParsingException(Exception e) {
            super(e);
        }
    }
}

