/*
 * Decompiled with CFR 0.152.
 */
package kupusoglu.orhan.sloc_maven_plugin.engine;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import kupusoglu.orhan.sloc_maven_plugin.engine.CountSLOC;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class CountLines {
    private Log log;
    private String baseDir;
    private String srcMain;
    private String fileExt;
    private boolean trimPkgNames;
    private boolean display;
    private boolean save;

    public CountLines() {
    }

    public CountLines(Log log, String baseDir, String srcMain, String fileExt, boolean trimPkgNames, boolean display, boolean save) {
        this();
        this.log = log;
        this.baseDir = baseDir;
        this.srcMain = srcMain;
        this.fileExt = fileExt;
        this.trimPkgNames = trimPkgNames;
        this.display = display;
        this.save = save;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (Files.exists(Paths.get(this.baseDir + File.separator + this.srcMain, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                CountSLOC countSLOC = new CountSLOC(this.log, this.baseDir, this.srcMain, this.fileExt, this.trimPkgNames, this.display, this.save);
                Files.walkFileTree(Paths.get(this.baseDir + File.separator + this.srcMain, new String[0]).toAbsolutePath(), countSLOC);
                countSLOC.done();
            } else {
                this.log.warn((CharSequence)("Does not contain a source directory: " + this.baseDir + File.separator + this.srcMain));
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)e.getMessage());
        }
    }
}

