/*
 * Decompiled with CFR 0.152.
 */
package kupusoglu.orhan.sloc_maven_plugin.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import kupusoglu.orhan.sloc_maven_plugin.engine.Common;
import org.apache.maven.plugin.logging.Log;

public class CountSLOC
extends SimpleFileVisitor<Path> {
    private Log log;
    private String baseDir;
    private String srcMain;
    private String fileExt;
    private boolean trimPkgNames;
    private boolean display;
    private boolean save;
    private PathMatcher matcherJava;
    private TreeMap<String, int[]> locData = new TreeMap();
    private boolean isblockComment = false;
    private boolean isblockDoc = false;
    private boolean isPackageFound = false;
    private String packageName;

    public CountSLOC() {
    }

    public CountSLOC(Log log, String baseDir, String srcMain, String fileExt, boolean trimPkgNames, boolean display, boolean save) {
        this();
        this.log = log;
        this.baseDir = baseDir;
        this.srcMain = srcMain;
        this.fileExt = fileExt;
        this.trimPkgNames = trimPkgNames;
        this.display = display;
        this.save = save;
        this.matcherJava = FileSystems.getDefault().getPathMatcher("glob:*." + fileExt);
    }

    public FileVisitResult collect(Path file) {
        Path name = file.getFileName();
        if (name != null) {
            Path absolutePathOfFile = file.toAbsolutePath().normalize();
            if (this.matcherJava.matches(name)) {
                this.processSource(absolutePathOfFile);
            } else {
                return FileVisitResult.CONTINUE;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    public void processSource(Path absolutePath) {
        int fileCounterTotal = 0;
        int fileCounterBlank = 0;
        int fileCounterComment = 0;
        int fileCounterJavaDoc = 0;
        List<String> lines = Common.readTextFile(absolutePath);
        fileCounterTotal = lines.size();
        this.isblockComment = false;
        this.isblockDoc = false;
        this.isPackageFound = false;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (this.isJavaDoc(trimmedLine)) {
                ++fileCounterJavaDoc;
                continue;
            }
            if (this.isComment(trimmedLine)) {
                ++fileCounterComment;
                continue;
            }
            if (this.isBlank(trimmedLine)) {
                ++fileCounterBlank;
                continue;
            }
            if (!this.isPackageFound && !this.isPackage(trimmedLine)) continue;
        }
        this.locData.put((this.packageName == null ? "" : this.packageName) + ":" + absolutePath.getFileName() + ":" + this.getFileType(absolutePath), new int[]{fileCounterBlank, fileCounterJavaDoc, fileCounterComment, fileCounterTotal - (fileCounterBlank + fileCounterJavaDoc + fileCounterComment)});
    }

    private boolean isBlank(String line) {
        return line.isEmpty();
    }

    private boolean isComment(String line) {
        if (line.endsWith("*/")) {
            if (this.isblockComment) {
                this.isblockComment = false;
                return true;
            }
            return false;
        }
        if (this.isblockComment) {
            return true;
        }
        if (line.startsWith("//")) {
            this.isblockComment = false;
            return true;
        }
        if (line.startsWith("/*") && !line.contains("*/")) {
            this.isblockComment = true;
            return true;
        }
        if (line.startsWith("/*") && line.endsWith("*/")) {
            this.isblockComment = false;
            return true;
        }
        return false;
    }

    private boolean isJavaDoc(String line) {
        if (line.endsWith("*/")) {
            if (this.isblockDoc) {
                this.isblockDoc = false;
                return true;
            }
            return false;
        }
        if (this.isblockDoc) {
            return true;
        }
        if (line.startsWith("/**") && !line.contains("*/")) {
            this.isblockDoc = true;
            return true;
        }
        if (line.startsWith("/**") && line.endsWith("*/")) {
            this.isblockDoc = false;
            return true;
        }
        return false;
    }

    private boolean isPackage(String line) {
        Matcher matcher = Common.PACKAGE_DECLARATION.matcher(line);
        this.isPackageFound = matcher.find();
        if (this.isPackageFound) {
            this.packageName = matcher.group(5);
        }
        return this.isPackageFound;
    }

    private String getFileType(Path path) {
        String pathStr = path.toString();
        if (pathStr.contains("/test/")) {
            return "test";
        }
        if (pathStr.contains("/integration-test/")) {
            return "int-test";
        }
        return "src";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        String data = Common.processSLOCData(this.locData, this.fileExt, this.trimPkgNames).toString();
        if (this.display) {
            if (data.length() > 0) {
                this.log.info((CharSequence)String.format("SLOC - directory: %s\n%s", this.baseDir + File.separator + this.srcMain, data));
            } else {
                this.log.warn((CharSequence)("Does not contain source files: " + this.baseDir + File.separator + this.srcMain + " : *." + this.fileExt));
            }
        }
        if (this.save) {
            File file = new File(this.baseDir + File.separator + "sloc.txt");
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.append(data);
                writer.flush();
            }
            catch (IOException e) {
                this.log.error((CharSequence)e.getMessage());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    this.log.error((CharSequence)e.getMessage());
                }
            }
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (attrs.isRegularFile()) {
            return this.collect(file);
        }
        this.log.warn((CharSequence)("ignored - not a regular file: " + file));
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException e) {
        this.log.error((CharSequence)e.getMessage());
        return FileVisitResult.CONTINUE;
    }
}

