/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.junit4;

import au.com.origin.snapshots.SnapshotVerifier;
import au.com.origin.snapshots.junit4.SharedSnapshotHelpers;
import au.com.origin.snapshots.logging.LoggingHelper;
import java.util.List;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = LoggerFactory.getLogger(SnapshotRunner.class);
    SnapshotVerifier snapshotVerifier;
    private SharedSnapshotHelpers helpers = new SharedSnapshotHelpers();

    public SnapshotRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        boolean isTest = method.getMethod().isAnnotationPresent(Test.class);
        if (isTest) {
            this.helpers.injectExpectInstanceVariable(this.snapshotVerifier, method.getMethod(), test);
            boolean shouldInjectMethodArgument = this.helpers.hasExpectArgument(method);
            if (shouldInjectMethodArgument) {
                LoggingHelper.deprecatedV5(log, "Injecting 'Expect' via method a argument is no longer recommended. Consider using instance variable injection instead.");
                return this.helpers.injectExpectMethodArgument(this.snapshotVerifier, method, test);
            }
        }
        return super.methodInvoker(method, test);
    }

    public void run(RunNotifier notifier) {
        this.snapshotVerifier = this.helpers.getSnapshotVerifier(this.getDescription());
        super.run(notifier);
        this.snapshotVerifier.validateSnapshots();
    }

    protected void validateTestMethods(List<Throwable> errors) {
    }
}

