/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.condition;

import shadow.org.assertj.core.api.Condition;
import shadow.org.assertj.core.condition.Join;

public class AllOf<T>
extends Join<T> {
    @SafeVarargs
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return new AllOf<T>(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return new AllOf<T>(conditions);
    }

    @SafeVarargs
    private AllOf(Condition<? super T> ... conditions) {
        super(conditions);
    }

    private AllOf(Iterable<? extends Condition<? super T>> conditions) {
        super(conditions);
    }

    @Override
    public boolean matches(T value) {
        return this.conditions.stream().allMatch(condition -> condition.matches(value));
    }

    @Override
    public String toString() {
        return String.format("all of:<%s>", this.conditions);
    }
}

