/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import shadow.org.assertj.core.util.Streams;

public final class Sets {
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        return Streams.stream(elements).collect(Collectors.toCollection(HashSet::new));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            return null;
        }
        LinkedHashSet<T> set = Sets.newLinkedHashSet();
        Collections.addAll(set, elements);
        return set;
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @SafeVarargs
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            return null;
        }
        TreeSet<T> set = Sets.newTreeSet();
        Collections.addAll(set, elements);
        return set;
    }

    private Sets() {
    }
}

