/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.SnapshotHeader;
import au.com.origin.snapshots.exceptions.LogGithubIssueException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Snapshot
implements Comparable<Snapshot> {
    private final String name;
    private final String scenario;
    private final SnapshotHeader header;
    private final String body;

    @Override
    public int compareTo(Snapshot other) {
        return (this.name + this.scenario).compareTo(other.name + other.scenario);
    }

    public String getIdentifier() {
        return this.scenario == null ? this.name : String.format("%s[%s]", this.name, this.scenario);
    }

    public static Snapshot parse(String rawText) {
        String regex = "^(?<name>.*?)(\\[(?<scenario>.*)\\])?=(?<header>\\{.*?\\})?(?<snapshot>(.*)$)";
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(rawText);
        boolean found = m.find();
        if (!found) {
            throw new LogGithubIssueException("Corrupt Snapshot (REGEX matches = 0): possibly due to manual editing or our REGEX failing\nPossible Solutions\n1. Ensure you have not accidentally manually edited the snapshot file!\n2. Compare the snapshot with GIT history");
        }
        String name = m.group("name");
        String scenario = m.group("scenario");
        String header = m.group("header");
        String snapshot = m.group("snapshot");
        if (name == null || snapshot == null) {
            throw new LogGithubIssueException("Corrupt Snapshot (REGEX name or snapshot group missing): possibly due to manual editing or our REGEX failing\nPossible Solutions\n1. Ensure you have not accidentally manually edited the snapshot file\n2. Compare the snapshot with your version control history");
        }
        return Snapshot.builder().name(name).scenario(scenario).header(SnapshotHeader.fromJson(header)).body(snapshot).build();
    }

    public String raw() {
        String headerJson = this.header == null || this.header.size() == 0 ? "" : this.header.toJson();
        return this.getIdentifier() + "=" + headerJson + this.body;
    }

    public String toString() {
        return this.raw();
    }

    public static SnapshotBuilder builder() {
        return new SnapshotBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$scenario = this.getScenario();
        String other$scenario = other.getScenario();
        if (this$scenario == null ? other$scenario != null : !this$scenario.equals(other$scenario)) {
            return false;
        }
        SnapshotHeader this$header = this.getHeader();
        SnapshotHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Snapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $scenario = this.getScenario();
        result = result * 59 + ($scenario == null ? 43 : $scenario.hashCode());
        SnapshotHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getScenario() {
        return this.scenario;
    }

    public SnapshotHeader getHeader() {
        return this.header;
    }

    public String getBody() {
        return this.body;
    }

    public Snapshot(String name, String scenario, SnapshotHeader header, String body) {
        this.name = name;
        this.scenario = scenario;
        this.header = header;
        this.body = body;
    }

    public static class SnapshotBuilder {
        private String name;
        private String scenario;
        private SnapshotHeader header;
        private String body;

        SnapshotBuilder() {
        }

        public SnapshotBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SnapshotBuilder scenario(String scenario) {
            this.scenario = scenario;
            return this;
        }

        public SnapshotBuilder header(SnapshotHeader header) {
            this.header = header;
            return this;
        }

        public SnapshotBuilder body(String body) {
            this.body = body;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this.name, this.scenario, this.header, this.body);
        }

        public String toString() {
            return "Snapshot.SnapshotBuilder(name=" + this.name + ", scenario=" + this.scenario + ", header=" + this.header + ", body=" + this.body + ")";
        }
    }
}

