/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.api.Condition;
import shadow.org.assertj.core.error.ShouldBe;
import shadow.org.assertj.core.error.ShouldHave;
import shadow.org.assertj.core.error.ShouldNotBe;
import shadow.org.assertj.core.error.ShouldNotHave;
import shadow.org.assertj.core.error.ShouldSatisfy;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.VisibleForTesting;

public class Conditions {
    private static final Conditions INSTANCE = new Conditions();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Conditions instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Conditions() {
    }

    public <T> void assertIs(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info, ShouldBe.shouldBe(actual, condition));
        }
    }

    public <T> void assertIsNot(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            throw this.failures.failure(info, ShouldNotBe.shouldNotBe(actual, condition));
        }
    }

    public <T> void assertHas(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info, ShouldHave.shouldHave(actual, condition));
        }
    }

    public <T> void assertDoesNotHave(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (condition.matches(actual)) {
            throw this.failures.failure(info, ShouldNotHave.shouldNotHave(actual, condition));
        }
    }

    public <T> void assertSatisfies(AssertionInfo info, T actual, Condition<? super T> condition) {
        this.assertIsNotNull(condition);
        if (!condition.matches(actual)) {
            throw this.failures.failure(info, ShouldSatisfy.shouldSatisfy(actual, condition));
        }
    }

    public void assertIsNotNull(Condition<?> condition) {
        this.assertIsNotNull(condition, "The condition to evaluate should not be null", new Object[0]);
    }

    public void assertIsNotNull(Condition<?> condition, String format, Object ... args) {
        Preconditions.checkNotNull(condition, String.format(format, args));
    }
}

