/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.RealNumbers;
import shadow.org.assertj.core.util.VisibleForTesting;

public class Floats
extends RealNumbers<Float> {
    private static final Floats INSTANCE = new Floats();

    public static Floats instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Floats() {
    }

    public Floats(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Float zero() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float one() {
        return Float.valueOf(1.0f);
    }

    @Override
    protected Float NaN() {
        return Float.valueOf(Float.NaN);
    }

    @Override
    protected Float absDiff(Float actual, Float other) {
        return Float.valueOf(Math.abs(other.floatValue() - actual.floatValue()));
    }
}

