/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.presentation;

import java.util.Formatter;
import shadow.org.assertj.core.presentation.StandardRepresentation;

public class UnicodeRepresentation
extends StandardRepresentation {
    public static final UnicodeRepresentation UNICODE_REPRESENTATION = new UnicodeRepresentation();

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof String) {
            return this.toStringOf((String)object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        return super.toStringOf(object);
    }

    @Override
    protected String toStringOf(Character string) {
        return UnicodeRepresentation.escapeUnicode(string.toString());
    }

    @Override
    protected String toStringOf(String string) {
        return UnicodeRepresentation.escapeUnicode(string);
    }

    private static String escapeUnicode(String input) {
        StringBuilder b = new StringBuilder(input.length());
        Formatter formatter = new Formatter(b);
        for (char c : input.toCharArray()) {
            if (c < '\u0080') {
                b.append(c);
                continue;
            }
            formatter.format("\\u%04x", c);
        }
        formatter.close();
        return b.toString();
    }
}

