/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.DeterministicJacksonSnapshotSerializer;
import au.com.origin.snapshots.serializers.JacksonSnapshotSerializer;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import au.com.origin.snapshots.serializers.ToStringSnapshotSerializer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.org.apache.commons.lang3.StringUtils;

public class Snapshot {
    private static final Logger log = LoggerFactory.getLogger(Snapshot.class);
    private final SnapshotConfig snapshotConfig;
    private final SnapshotFile snapshotFile;
    private final Class<?> testClass;
    private final Method testMethod;
    private final Object[] current;
    private final boolean isCI;
    private SnapshotSerializer snapshotSerializer;
    private SnapshotComparator snapshotComparator;
    private List<SnapshotReporter> snapshotReporters;
    private String scenario;

    Snapshot(SnapshotConfig snapshotConfig, SnapshotFile snapshotFile, Class<?> testClass, Method testMethod, Object ... current) {
        this(snapshotConfig, snapshotFile, testClass, testMethod, current, snapshotConfig.isCI(), snapshotConfig.getSerializer(), snapshotConfig.getComparator(), snapshotConfig.getReporters(), null);
    }

    public Snapshot scenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    public Snapshot serializer(SnapshotSerializer serializer) {
        this.snapshotSerializer = serializer;
        return this;
    }

    public Snapshot comparator(SnapshotComparator comparator) {
        this.snapshotComparator = comparator;
        return this;
    }

    public Snapshot reporters(SnapshotReporter ... reporters) {
        this.snapshotReporters = Arrays.asList(reporters);
        return this;
    }

    public Snapshot string() {
        return this.serializer(new ToStringSnapshotSerializer());
    }

    public Snapshot json() {
        return this.serializer(new JacksonSnapshotSerializer());
    }

    public Snapshot orderedJson() {
        return this.serializer(new DeterministicJacksonSnapshotSerializer());
    }

    public Snapshot serializer(Class<? extends SnapshotSerializer> serializer) {
        this.snapshotSerializer = serializer.getConstructor(new Class[0]).newInstance(new Object[0]);
        return this;
    }

    public void toMatchSnapshot() {
        Set<String> rawSnapshots = this.snapshotFile.getRawSnapshots();
        String rawSnapshot = this.getRawSnapshot(rawSnapshots);
        String currentObject = this.takeSnapshot();
        if (rawSnapshot != null && this.shouldUpdateSnapshot()) {
            this.snapshotFile.getRawSnapshots().remove(rawSnapshot);
            rawSnapshot = null;
        }
        if (rawSnapshot != null) {
            if (!this.snapshotComparator.matches(this.getSnapshotName(), rawSnapshot, currentObject)) {
                this.snapshotFile.createDebugFile(currentObject.trim());
                List reporters = this.snapshotReporters.stream().filter(reporter -> reporter.supportsFormat(this.snapshotSerializer.getOutputFormat())).collect(Collectors.toList());
                if (reporters.isEmpty()) {
                    String comparator = this.snapshotComparator.getClass().getSimpleName();
                    throw new IllegalStateException("No compatible reporters found for comparator " + comparator);
                }
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                for (SnapshotReporter reporter2 : reporters) {
                    try {
                        reporter2.report(this.getSnapshotName(), rawSnapshot, currentObject);
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new SnapshotMatchException("Error(s) matching snapshot(s)", (List<Throwable>)errors);
                }
            }
        } else {
            if (this.isCI) {
                log.error("We detected you are running on a CI Server - if this is incorrect please override the isCI() method in SnapshotConfig");
                throw new SnapshotMatchException("Snapshot [" + this.getSnapshotName() + "] not found. Has this snapshot been committed ?");
            }
            log.warn("We detected you are running on a developer machine - if this is incorrect please override the isCI() method in SnapshotConfig");
            this.snapshotFile.push(currentObject);
        }
        this.snapshotFile.deleteDebugFile();
    }

    private boolean shouldUpdateSnapshot() {
        if (this.snapshotConfig.updateSnapshot().isPresent()) {
            return this.getSnapshotName().contains(this.snapshotConfig.updateSnapshot().get());
        }
        return false;
    }

    private String getRawSnapshot(Collection<String> rawSnapshots) {
        for (String rawSnapshot : rawSnapshots) {
            if (!rawSnapshot.contains(this.getSnapshotName())) continue;
            return rawSnapshot;
        }
        return null;
    }

    private String takeSnapshot() {
        return this.getSnapshotName() + (String)this.snapshotSerializer.apply(this.current);
    }

    String getSnapshotName() {
        String scenarioFormat = StringUtils.isBlank(this.scenario) ? "" : "[" + this.scenario + "]";
        return this.testClass.getName() + "." + this.testMethod.getName() + scenarioFormat + "=";
    }

    private Snapshot(SnapshotConfig snapshotConfig, SnapshotFile snapshotFile, Class<?> testClass, Method testMethod, Object[] current, boolean isCI, SnapshotSerializer snapshotSerializer, SnapshotComparator snapshotComparator, List<SnapshotReporter> snapshotReporters, String scenario) {
        this.snapshotConfig = snapshotConfig;
        this.snapshotFile = snapshotFile;
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.current = current;
        this.isCI = isCI;
        this.snapshotSerializer = snapshotSerializer;
        this.snapshotComparator = snapshotComparator;
        this.snapshotReporters = snapshotReporters;
        this.scenario = scenario;
    }

    Snapshot withSnapshotFile(SnapshotFile snapshotFile) {
        return this.snapshotFile == snapshotFile ? this : new Snapshot(this.snapshotConfig, snapshotFile, this.testClass, this.testMethod, this.current, this.isCI, this.snapshotSerializer, this.snapshotComparator, this.snapshotReporters, this.scenario);
    }

    Snapshot withCurrent(Object[] current) {
        return this.current == current ? this : new Snapshot(this.snapshotConfig, this.snapshotFile, this.testClass, this.testMethod, current, this.isCI, this.snapshotSerializer, this.snapshotComparator, this.snapshotReporters, this.scenario);
    }
}

