/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.exceptions.SnapshotExtensionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

class SnapshotCaptor {
    private Class<?> parameterClass;
    private Class<?> argumentClass;
    private String[] ignore;

    public SnapshotCaptor(Class<?> parameterClass, String ... ignore) {
        this.parameterClass = parameterClass;
        this.argumentClass = parameterClass;
        this.ignore = ignore;
    }

    public SnapshotCaptor(Class<?> parameterClass, Class<?> argumentClass, String ... ignore) {
        this.parameterClass = parameterClass;
        this.argumentClass = argumentClass;
        this.ignore = ignore;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public Object removeIgnored(Object value) {
        Object newValue = value;
        if (this.ignore != null && this.ignore.length > 0) {
            newValue = this.shallowCopy(value);
            for (String each : this.ignore) {
                try {
                    Field field = this.argumentClass.getDeclaredField(each);
                    field.setAccessible(true);
                    if (field.getType().isPrimitive()) {
                        field.setByte(newValue, Integer.valueOf(0).byteValue());
                        continue;
                    }
                    field.set(newValue, null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new SnapshotExtensionException("Invalid Ignore value " + each, e.getCause());
                }
            }
        }
        return newValue;
    }

    private Object shallowCopy(Object value) {
        try {
            Field[] fields;
            Object newValue = this.constructCopy(this.argumentClass);
            for (Field field : fields = this.argumentClass.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    field.set(newValue, field.get(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }
        catch (Exception e) {
            throw new SnapshotExtensionException("Class " + this.argumentClass.getSimpleName() + " must have a default empty constructor!");
        }
    }

    private Object constructCopy(Class<?> argumentClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            return argumentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Constructor<?>[] constructors = argumentClass.getDeclaredConstructors();
            if (constructors.length == 0) {
                return argumentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            int i = 0;
            Class<?>[] types = constructors[i].getParameterTypes();
            Object[] paramValues = new Object[types.length];
            for (int j = 0; j < types.length; ++j) {
                paramValues[j] = types[j].isPrimitive() ? Byte.valueOf(Integer.valueOf(0).byteValue()) : this.constructCopy(types[j]);
            }
            return constructors[i].newInstance(paramValues);
        }
    }
}

