/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.comparators.PlainTextEqualsComparator;
import au.com.origin.snapshots.comparators.SnapshotComparator;
import au.com.origin.snapshots.reporters.PlainTextSnapshotReporter;
import au.com.origin.snapshots.reporters.SnapshotReporter;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import au.com.origin.snapshots.serializers.ToStringSnapshotSerializer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.org.apache.commons.lang3.StringUtils;

public interface SnapshotConfig {
    public static final String JVM_UPDATE_SNAPSHOTS_PARAMETER = "updateSnapshot";

    @Deprecated
    default public String getTestDir() {
        return this.getOutputDir();
    }

    default public String getOutputDir() {
        return "src/test/java";
    }

    default public String getSnapshotFolder() {
        return "__snapshots__";
    }

    public Class<?> getTestClass();

    public Method getTestMethod(Class<?> var1);

    default public Optional<String> updateSnapshot() {
        return Optional.ofNullable(System.getProperty(JVM_UPDATE_SNAPSHOTS_PARAMETER));
    }

    default public SnapshotSerializer getSerializer() {
        return new ToStringSnapshotSerializer();
    }

    default public String onSaveSnapshotFile(Class<?> testClass, String snapshotContent) {
        return snapshotContent;
    }

    default public SnapshotComparator getComparator() {
        return new PlainTextEqualsComparator();
    }

    default public List<SnapshotReporter> getReporters() {
        return Collections.singletonList(new PlainTextSnapshotReporter());
    }

    default public boolean isCI() {
        return StringUtils.isNotEmpty(System.getenv("CI"));
    }
}

