/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.SnapshotVerifier;
import au.com.origin.snapshots.annotations.UseSnapshotConfig;
import au.com.origin.snapshots.exceptions.SnapshotExtensionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotMatcher {
    private static final Logger log = LoggerFactory.getLogger(SnapshotMatcher.class);
    private static final ThreadLocal<SnapshotVerifier> INSTANCES = new ThreadLocal();
    private static final ThreadLocal<Boolean> SNAPSHOT_TEST_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void start(SnapshotConfig config) {
        SnapshotMatcher.start(config, false, config.getTestClass());
    }

    public static void start(SnapshotConfig config, boolean failOnOrphans) {
        SnapshotMatcher.start(config, failOnOrphans, config.getTestClass());
    }

    public static void start(SnapshotConfig defaultConfig, boolean failOnOrphans, Class<?> testClass) {
        try {
            UseSnapshotConfig customConfig = testClass.getAnnotation(UseSnapshotConfig.class);
            SnapshotConfig resolvedConfig = customConfig == null ? defaultConfig : customConfig.value().newInstance();
            String testFilename = testClass.getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".snap";
            File fileUnderTest = new File(testFilename);
            File snapshotDir = new File(fileUnderTest.getParentFile(), resolvedConfig.getSnapshotFolder());
            String testSrcDir = resolvedConfig.getOutputDir();
            String testSrcDirNoTrailing = testSrcDir.endsWith("/") ? resolvedConfig.getOutputDir().substring(0, testSrcDir.length() - 1) : resolvedConfig.getOutputDir();
            SnapshotFile snapshotFile = new SnapshotFile(testSrcDirNoTrailing, snapshotDir.getPath() + File.separator + fileUnderTest.getName(), testClass, resolvedConfig::onSaveSnapshotFile);
            SnapshotVerifier snapshotVerifier = new SnapshotVerifier(testClass, snapshotFile, resolvedConfig, failOnOrphans);
            SNAPSHOT_TEST_IN_PROGRESS.set(true);
            INSTANCES.set(snapshotVerifier);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new SnapshotExtensionException(e.getMessage());
        }
    }

    public static void setTestMethod(Method method) {
        SnapshotMatcher.getSnapshotVerifier().setTestMethod(method);
    }

    public static void validateSnapshots() {
        SnapshotMatcher.getSnapshotVerifier().validateSnapshots();
        SNAPSHOT_TEST_IN_PROGRESS.set(false);
    }

    public static Snapshot expect(Object firstObject, Object ... objects) {
        if (!SNAPSHOT_TEST_IN_PROGRESS.get().booleanValue()) {
            throw new SnapshotExtensionException("setTestMethod() not called! Has SnapshotMatcher.start() been called?");
        }
        return SnapshotMatcher.getSnapshotVerifier().expectCondition(firstObject, objects);
    }

    private static SnapshotVerifier getSnapshotVerifier() {
        SnapshotVerifier instance = INSTANCES.get();
        if (instance == null) {
            throw new SnapshotExtensionException("Unable to locate SnapshotVerifier instance! Has SnapshotMatcher.start() been called?");
        }
        return instance;
    }
}

