/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots;

import au.com.origin.snapshots.Snapshot;
import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotFile;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.org.apache.commons.lang3.ArrayUtils;
import shadow.org.apache.commons.lang3.StringUtils;
import shadow.org.assertj.core.util.Arrays;

public class SnapshotVerifier {
    private static final Logger log = LoggerFactory.getLogger(SnapshotVerifier.class);
    private final Class<?> testClass;
    private final SnapshotFile snapshotFile;
    private final SnapshotConfig config;
    private final boolean failOnOrphans;
    private final List<Snapshot> calledSnapshots = new ArrayList<Snapshot>();
    private Method testMethod = null;

    public Snapshot expectCondition(Object firstObject, Object ... others) {
        Object[] objects = this.mergeObjects(firstObject, others);
        Method resolvedTestMethod = this.testMethod == null ? this.config.getTestMethod(this.testClass) : this.testMethod;
        Snapshot snapshot = new Snapshot(this.config, this.snapshotFile, this.testClass, resolvedTestMethod, objects);
        this.calledSnapshots.add(snapshot);
        return snapshot;
    }

    public void validateSnapshots() {
        Set<String> rawSnapshots = this.snapshotFile.getRawSnapshots();
        Set snapshotNames = this.calledSnapshots.stream().map(Snapshot::getSnapshotName).collect(Collectors.toSet());
        ArrayList<String> unusedRawSnapshots = new ArrayList<String>();
        for (String rawSnapshot : rawSnapshots) {
            boolean foundSnapshot = false;
            for (String snapshotName : snapshotNames) {
                if (!rawSnapshot.contains(snapshotName)) continue;
                foundSnapshot = true;
                break;
            }
            if (foundSnapshot) continue;
            unusedRawSnapshots.add(rawSnapshot);
        }
        if (unusedRawSnapshots.size() > 0) {
            String errorMessage = "All unused Snapshots:\n" + StringUtils.join(unusedRawSnapshots, "\n") + "\n\nHave you deleted tests? Have you renamed a test method?";
            if (this.failOnOrphans) {
                log.warn(errorMessage);
                throw new SnapshotMatchException("ERROR: Found orphan snapshots");
            }
            log.warn(errorMessage);
        }
        this.snapshotFile.cleanup();
    }

    private Object[] mergeObjects(Object firstObject, Object[] others) {
        Object[] objects = new Object[]{firstObject};
        if (!Arrays.isNullOrEmpty(others)) {
            objects = ArrayUtils.addAll(objects, others);
        }
        return objects;
    }

    public SnapshotVerifier(Class<?> testClass, SnapshotFile snapshotFile, SnapshotConfig config, boolean failOnOrphans) {
        this.testClass = testClass;
        this.snapshotFile = snapshotFile;
        this.config = config;
        this.failOnOrphans = failOnOrphans;
    }

    public void setTestMethod(Method testMethod) {
        this.testMethod = testMethod;
    }
}

