/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.junit5;

import au.com.origin.snapshots.SnapshotConfig;
import au.com.origin.snapshots.SnapshotConfigInjector;
import au.com.origin.snapshots.SnapshotMatcher;
import au.com.origin.snapshots.exceptions.SnapshotMatchException;
import au.com.origin.snapshots.junit5.JUnit5SnapshotConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;

public class SnapshotExtension
implements AfterAllCallback,
BeforeAllCallback,
BeforeEachCallback,
SnapshotConfigInjector {
    public void beforeAll(ExtensionContext context) {
        boolean failOnOrphans = this.shouldFailOnOrphans(context);
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new SnapshotMatchException("Unable to locate Test class"));
        SnapshotMatcher.start(this.getSnapshotConfig(), failOnOrphans, testClass);
    }

    public void afterAll(ExtensionContext context) {
        SnapshotMatcher.validateSnapshots();
    }

    public void beforeEach(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(() -> new SnapshotMatchException("Unable to locate Test class"));
        SnapshotMatcher.setTestMethod(method);
    }

    @Override
    public SnapshotConfig getSnapshotConfig() {
        return new JUnit5SnapshotConfig();
    }

    private boolean shouldFailOnOrphans(ExtensionContext context) {
        try {
            Field field = context.getClass().getSuperclass().getDeclaredField("testDescriptor");
            field.setAccessible(true);
            ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)field.get(context);
            return classTestDescriptor.getChildren().size() > 1;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            System.err.println("FAILED: (Java Snapshot Testing) Unable to get JUnit5 ClassTestDescriptor!\nEnsure you are using Junit5 >= 5.3.2\nThis may be due to JUnit5 changing their private api as we use reflection to access it\nLog a support ticket https://github.com/origin-energy/java-snapshot-testing/issues and supply your JUnit5 version\nSetting failOnOrphans=true as this is the safest option.This means that running a test alone (say from the IDE) will fail the snapshot, you need to run the entire class.");
            return true;
        }
    }
}

