/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeterministicCollectionModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(DeterministicCollectionModule.class);

    public DeterministicCollectionModule() {
        this.addSerializer(Collection.class, new CollectionSerializer());
    }

    private static class CollectionSerializer
    extends JsonSerializer<Collection> {
        private CollectionSerializer() {
        }

        public void serialize(Collection value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Object[] sorted = this.convert(value);
            serializers.defaultSerializeValue((Object)sorted, gen);
        }

        private Object[] convert(Collection<?> value) {
            if (value == null || value.isEmpty()) {
                return Collections.emptyList().toArray();
            }
            try {
                return value.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList()).toArray();
            }
            catch (ClassCastException ex) {
                log.warn("Unable to sort() collection - this may result in a non deterministic snapshot.\nConsider adding a custom serializer for this type via the JacksonSnapshotSerializer#configure() method.\n" + ex.getMessage());
                return value.toArray();
            }
        }
    }
}

