/*
 * Decompiled with CFR 0.152.
 */
package au.com.origin.snapshots.serializers;

import au.com.origin.snapshots.exceptions.SnapshotExtensionException;
import au.com.origin.snapshots.serializers.SerializerType;
import au.com.origin.snapshots.serializers.SnapshotSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class JacksonSnapshotSerializer
implements SnapshotSerializer {
    private final PrettyPrinter pp = new DefaultPrettyPrinter(""){
        {
            DefaultIndenter lfOnlyIndenter = new DefaultIndenter("  ", "\n");
            this.indentArraysWith((DefaultPrettyPrinter.Indenter)lfOnlyIndenter);
            this.indentObjectsWith((DefaultPrettyPrinter.Indenter)lfOnlyIndenter);
        }

        public DefaultPrettyPrinter createInstance() {
            return new DefaultPrettyPrinter((DefaultPrettyPrinter)this);
        }

        public DefaultPrettyPrinter withSeparators(Separators separators) {
            this._separators = separators;
            this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
            return this;
        }
    };
    private final ObjectMapper objectMapper = new ObjectMapper(){
        {
            this.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            this.enable(SerializationFeature.WRITE_DATES_WITH_ZONE_ID);
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.registerModule((Module)new JavaTimeModule());
            this.registerModule((Module)new Jdk8Module());
            this.setVisibility(this.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
            JacksonSnapshotSerializer.this.configure(this);
        }
    };

    public void configure(ObjectMapper objectMapper) {
    }

    @Override
    public String apply(Object[] objects) {
        try {
            return this.objectMapper.writer(this.pp).writeValueAsString((Object)objects);
        }
        catch (Exception e) {
            throw new SnapshotExtensionException("Jackson Serialization failed", e);
        }
    }

    @Override
    public String getOutputFormat() {
        return SerializerType.JSON.name();
    }
}

