/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.lang.reflect.Field;
import java.util.List;
import shadow.org.assertj.core.api.SoftAssertionError;
import shadow.org.assertj.core.api.SoftProxies;
import shadow.org.assertj.core.error.ConstructorInvoker;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.util.Arrays;
import shadow.org.assertj.core.util.Throwables;

public class AbstractSoftAssertions {
    private static final Class<?>[] MULTIPLE_FAILURES_ERROR_ARGUMENT_TYPES = Arrays.array(String.class, List.class);
    protected final SoftProxies proxies = new SoftProxies();

    public <T, V> V proxy(Class<V> assertClass, Class<T> actualClass, T actual) {
        return this.proxies.createSoftAssertionProxy(assertClass, actualClass, actual);
    }

    public void fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Object ... args) {
        AssertionError error = Failures.instance().failure(String.format(failureMessage, args));
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public List<Throwable> errorsCollected() {
        return this.decorateErrorsCollected(this.proxies.errorsCollected());
    }

    protected List<Throwable> decorateErrorsCollected(List<Throwable> errors) {
        return this.addLineNumberToErrorMessages(errors);
    }

    public boolean wasSuccess() {
        return this.proxies.wasSuccess();
    }

    private List<Throwable> addLineNumberToErrorMessages(List<Throwable> errors) {
        errors.forEach(this::addLineNumberToErrorMessage);
        return errors;
    }

    private void addLineNumberToErrorMessage(Throwable error) {
        StackTraceElement testStackTraceElement = this.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            this.changeErrorMessage(error, this.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement));
        }
    }

    private String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        String testClassName = this.simpleClassNameOf(testStackTraceElement);
        String testName = testStackTraceElement.getMethodName();
        int lineNumber = testStackTraceElement.getLineNumber();
        return String.format("%s%nat %s.%s(%s.java:%s)", originalErrorMessage, testClassName, testName, testClassName, lineNumber);
    }

    private void changeErrorMessage(Throwable error, String errorMessageWithLineNumber) {
        try {
            Field field = Throwable.class.getDeclaredField("detailMessage");
            field.setAccessible(true);
            field.set(error, errorMessageWithLineNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (this.isProxiedAssertionClass(className) || className.startsWith("sun.reflect") || className.startsWith("jdk.internal.reflect") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.eclipse.jdt.internal.junit5.") || className.startsWith("com.intellij.junit5.") || className.startsWith("com.intellij.rt.execution.junit.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("shadow.org.assertj")) continue;
            return element;
        }
        return null;
    }

    private boolean isProxiedAssertionClass(String className) {
        return className.contains("$ByteBuddy$");
    }

    protected static void throwsBestMultipleAssertionsError(List<Throwable> errors) {
        AbstractSoftAssertions.tryThrowingMultipleFailuresError(errors);
        throw new SoftAssertionError(Throwables.describeErrors(errors));
    }

    protected static void tryThrowingMultipleFailuresError(List<Throwable> errorsCollected) {
        if (errorsCollected.isEmpty()) {
            return;
        }
        try {
            Object[] constructorArguments = Arrays.array(null, errorsCollected);
            Object multipleFailuresError = ConstructorInvoker.CONSTRUCTOR_INVOKER.newInstance("org.opentest4j.MultipleFailuresError", MULTIPLE_FAILURES_ERROR_ARGUMENT_TYPES, constructorArguments);
            if (multipleFailuresError instanceof AssertionError) {
                AssertionError assertionError = (AssertionError)multipleFailuresError;
                Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
                throw assertionError;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

