/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.api;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import shadow.org.assertj.core.api.AbstractAssert;
import shadow.org.assertj.core.api.AbstractCharSequenceAssert;
import shadow.org.assertj.core.api.AbstractComparableAssert;
import shadow.org.assertj.core.api.AbstractPathAssert;
import shadow.org.assertj.core.api.AssertDelegateTarget;
import shadow.org.assertj.core.api.AssertFactory;
import shadow.org.assertj.core.api.AssertProvider;
import shadow.org.assertj.core.api.AssertionsForClassTypes;
import shadow.org.assertj.core.api.CharSequenceAssert;
import shadow.org.assertj.core.api.ClassBasedNavigableIterableAssert;
import shadow.org.assertj.core.api.ClassBasedNavigableListAssert;
import shadow.org.assertj.core.api.CompletableFutureAssert;
import shadow.org.assertj.core.api.DoublePredicateAssert;
import shadow.org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import shadow.org.assertj.core.api.FactoryBasedNavigableListAssert;
import shadow.org.assertj.core.api.GenericComparableAssert;
import shadow.org.assertj.core.api.IntPredicateAssert;
import shadow.org.assertj.core.api.IterableAssert;
import shadow.org.assertj.core.api.ListAssert;
import shadow.org.assertj.core.api.LongPredicateAssert;
import shadow.org.assertj.core.api.MapAssert;
import shadow.org.assertj.core.api.PathAssert;
import shadow.org.assertj.core.api.PredicateAssert;
import shadow.org.assertj.core.util.CheckReturnValue;

public class AssertionsForInterfaceTypes
extends AssertionsForClassTypes {
    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    protected AssertionsForInterfaceTypes() {
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return new CharSequenceAssert(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterable<? extends ELEMENT> actual) {
        return new IterableAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterator<? extends ELEMENT> actual) {
        return new IterableAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> ListAssert<ELEMENT> assertThat(List<? extends ELEMENT> actual) {
        return new ListAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> ListAssert<ELEMENT> assertThat(Stream<? extends ELEMENT> actual) {
        return new ListAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static ListAssert<Double> assertThat(DoubleStream actual) {
        return new ListAssert<Double>(actual);
    }

    @CheckReturnValue
    public static ListAssert<Long> assertThat(LongStream actual) {
        return new ListAssert<Long>(actual);
    }

    @CheckReturnValue
    public static ListAssert<Integer> assertThat(IntStream actual) {
        return new ListAssert<Integer>(actual);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(Iterable<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableIterableAssert(actual, FactoryBasedNavigableIterableAssert.class, assertFactory);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableIterableAssert(actual, ClassBasedNavigableIterableAssert.class, assertClass);
    }

    public static <ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableListAssert(actual, FactoryBasedNavigableListAssert.class, assertFactory);
    }

    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableListAssert(actual, assertClass);
    }

    @CheckReturnValue
    public static AbstractPathAssert<?> assertThat(Path actual) {
        return new PathAssert(actual);
    }

    @CheckReturnValue
    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return new MapAssert<K, V>(actual);
    }

    @CheckReturnValue
    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    @CheckReturnValue
    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    @CheckReturnValue
    public static <T> PredicateAssert<T> assertThat(Predicate<T> actual) {
        return new PredicateAssert<T>(actual);
    }

    @CheckReturnValue
    public static IntPredicateAssert assertThat(IntPredicate actual) {
        return new IntPredicateAssert(actual);
    }

    @CheckReturnValue
    public static LongPredicateAssert assertThat(LongPredicate actual) {
        return new LongPredicateAssert(actual);
    }

    @CheckReturnValue
    public static DoublePredicateAssert assertThat(DoublePredicate actual) {
        return new DoublePredicateAssert(actual);
    }

    @CheckReturnValue
    public static <RESULT> CompletableFutureAssert<RESULT> assertThat(CompletionStage<RESULT> actual) {
        return new CompletableFutureAssert<RESULT>(actual);
    }
}

